/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.compat.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.servlets.get.impl.helpers.JsonResourceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"Default Query Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"query"}), @Property(name="sling.servlet.prefix", intValue={-1}, propertyPrivate=true)})
public class JsonQueryServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(JsonQueryServlet.class);
    public static final String STATEMENT = "statement";
    public static final String QUERY_TYPE = "queryType";
    public static final String OFFSET = "offset";
    public static final String ROWS = "rows";
    public static final String PROPERTY = "property";
    public static final String EXCERPT_PATH = "excerptPath";
    private static final String REP_EXCERPT = "rep:excerpt()";
    public static final String TIDY = "tidy";
    private final JsonResourceWriter itemWriter = new JsonResourceWriter(null);

    protected boolean isTidy(SlingHttpServletRequest req) {
        for (String selector : req.getRequestPathInfo().getSelectors()) {
            if (!TIDY.equals(selector)) continue;
            return true;
        }
        return false;
    }

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws IOException {
        this.dumpResult(req, resp);
    }

    protected String getQueryType(SlingHttpServletRequest req) {
        return req.getParameter(QUERY_TYPE);
    }

    protected String getStatement(SlingHttpServletRequest req, String queryType) {
        return req.getParameter(STATEMENT);
    }

    private void dumpResult(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws IOException {
        try {
            ResourceResolver resolver = req.getResourceResolver();
            String queryType = this.getQueryType(req);
            String statement = this.getStatement(req, queryType);
            Iterator result = resolver.queryResources(statement, queryType);
            if (req.getParameter(OFFSET) != null) {
                for (long skip = Long.parseLong(req.getParameter(OFFSET)); skip > 0L && result.hasNext(); --skip) {
                    result.next();
                }
            }
            resp.setContentType(req.getResponseContentType());
            resp.setCharacterEncoding("UTF-8");
            JSONWriter w = new JSONWriter((Writer)resp.getWriter());
            w.setTidy(this.isTidy(req));
            w.array();
            long count = -1L;
            if (req.getParameter(ROWS) != null) {
                count = Long.parseLong(req.getParameter(ROWS));
            }
            ArrayList<String> properties = new ArrayList<String>();
            if (req.getParameterValues(PROPERTY) != null) {
                for (String property : req.getParameterValues(PROPERTY)) {
                    properties.add(property);
                }
            }
            String exerptPath = "";
            if (req.getParameter(EXCERPT_PATH) != null) {
                exerptPath = req.getParameter(EXCERPT_PATH);
            }
            while (result.hasNext() && count != 0L) {
                Map row = (Map)result.next();
                w.object();
                String path = row.get("jcr:path").toString();
                w.key("name");
                w.value((Object)ResourceUtil.getName((String)path));
                for (String colName : row.keySet()) {
                    w.key(colName);
                    String strValue = "";
                    if (colName.equals(REP_EXCERPT)) {
                        Object ev = row.get("rep:excerpt(" + exerptPath + ")");
                        strValue = ev == null ? "" : ev.toString();
                        w.value((Object)strValue);
                        continue;
                    }
                    this.itemWriter.dumpValue(w, row.get(colName));
                }
                if (!properties.isEmpty()) {
                    Resource nodeRes = resolver.getResource(path);
                    this.dumpProperties(w, nodeRes, properties);
                }
                w.endObject();
                --count;
            }
            w.endArray();
        }
        catch (JSONException je) {
            throw this.wrapException((Exception)((Object)je));
        }
    }

    private void dumpProperties(JSONWriter w, Resource nodeRes, List<String> properties) throws JSONException {
        if (nodeRes == null) {
            return;
        }
        this.itemWriter.dumpProperties(nodeRes, w, properties);
    }

    private SlingException wrapException(Exception e) {
        this.log.warn("Error in QueryServlet: " + e.toString(), (Throwable)e);
        return new SlingException(e.toString(), (Throwable)e);
    }
}

