/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.remote.testrunner;

import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.sling.jcr.contentparser.impl.JsonTicksConverter;
import org.apache.sling.junit.remote.httpclient.RemoteTestHttpClient;
import org.apache.sling.junit.remote.testrunner.SlingRemoteTest;
import org.apache.sling.junit.remote.testrunner.SlingRemoteTestParameters;
import org.apache.sling.junit.remote.testrunner.SlingTestsCountChecker;
import org.apache.sling.testing.tools.http.RequestCustomizer;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.junit.After;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingRemoteTestRunner
extends ParentRunner<SlingRemoteTest> {
    private static final Logger log = LoggerFactory.getLogger(SlingRemoteTestRunner.class);
    private final SlingRemoteTestParameters testParameters;
    private RemoteTestHttpClient testHttpClient;
    private final String username;
    private final String password;
    private final Class<?> testClass;
    private final List<SlingRemoteTest> children = new LinkedList<SlingRemoteTest>();

    public SlingRemoteTestRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.testClass = testClass;
        Object o = null;
        try {
            o = testClass.newInstance();
            if (!(o instanceof SlingRemoteTestParameters)) {
                throw new IllegalArgumentException(o.getClass().getName() + " is not a " + SlingRemoteTestParameters.class.getSimpleName());
            }
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
        String configuredUsername = System.getProperty("test.server.username");
        this.username = configuredUsername != null && configuredUsername.trim().length() > 0 ? configuredUsername : "admin";
        String configuredPassword = System.getProperty("test.server.password");
        this.password = configuredPassword != null && configuredPassword.trim().length() > 0 ? configuredPassword : "admin";
        this.testParameters = (SlingRemoteTestParameters)o;
    }

    private void maybeExecuteTests() throws Exception {
        if (this.testHttpClient != null) {
            return;
        }
        this.testHttpClient = new RemoteTestHttpClient(this.testParameters.getJunitServletUrl(), this.username, this.password, true);
        if (this.testParameters instanceof RequestCustomizer) {
            this.testHttpClient.setRequestCustomizer((RequestCustomizer)this.testParameters);
        }
        RequestExecutor executor = this.testHttpClient.runTests(this.testParameters.getTestClassesSelector(), this.testParameters.getTestMethodSelector(), "json");
        executor.assertContentType("application/json");
        JsonArray json = Json.createReader((Reader)new StringReader(JsonTicksConverter.tickToDoubleQuote(executor.getContent()))).readArray();
        for (int i = 0; i < json.size(); ++i) {
            JsonObject obj = json.getJsonObject(i);
            if (!obj.containsKey((Object)"INFO_TYPE") || !"test".equals(obj.getString("INFO_TYPE"))) continue;
            this.children.add(new SlingRemoteTest(this.testClass, obj));
        }
        log.info("Server-side tests executed as {} at {} with path {}", new Object[]{this.username, this.testParameters.getJunitServletUrl(), this.testHttpClient.getTestExecutionPath()});
        if (this.testParameters instanceof SlingTestsCountChecker) {
            ((SlingTestsCountChecker)((Object)this.testParameters)).checkNumberOfTests(this.children.size());
        }
    }

    protected Description describeChild(SlingRemoteTest t) {
        return t.describe();
    }

    protected List<SlingRemoteTest> getChildren() {
        try {
            this.maybeExecuteTests();
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(SlingRemoteTest t, RunNotifier notifier) {
        try {
            this.maybeExecuteTests();
        }
        catch (Exception e) {
            throw new Error(e);
        }
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, t.describe());
        eachNotifier.fireTestStarted();
        try {
            log.debug("Running test {}", (Object)t.describe());
            t.run();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
        finally {
            eachNotifier.fireTestFinished();
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        Statement statement = this.childrenInvoker(notifier);
        statement = this.withBeforeClasses(statement);
        statement = this.withAfter(statement);
        statement = this.withAfterClasses(statement);
        return statement;
    }

    private Statement withAfter(Statement statement) {
        List afters = this.getTestClass().getAnnotatedMethods(After.class);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, (Object)this.testParameters);
    }
}

