/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.fileoptim.FileOptimizer;
import org.apache.sling.fileoptim.FileOptimizerService;
import org.apache.sling.fileoptim.impl.FileOptimizerServiceImpl;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Web Console Plugin for Apache Sling File Optimizer", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=fileoptim", "felix.webconsole.title=File Optimizer", "felix.webconsole.configprinter.modes=always", "felix.webconsole.category=Status"}, service={Servlet.class})
public class FileOptimizerWebConsole
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = 7086113364871387281L;
    public static final String CONSOLE_LABEL = "fileoptim";
    public static final String CONSOLE_TITLE = "File Optimizer";
    @Reference
    private transient FileOptimizerService fileOptimizer;

    public String getTitle() {
        return CONSOLE_TITLE;
    }

    public String getLabel() {
        return CONSOLE_LABEL;
    }

    protected void renderContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter pw = httpServletResponse.getWriter();
        pw.println("<div id='content' class='ui-widget'><br>");
        pw.println("<pre>");
        pw.println("Available Optimizers");
        pw.println("========================");
        Map<String, List<ServiceReference<FileOptimizer>>> optimizerCache = ((FileOptimizerServiceImpl)this.fileOptimizer).getFileOptimizers();
        for (Map.Entry<String, List<ServiceReference<FileOptimizer>>> to : optimizerCache.entrySet()) {
            pw.println();
            pw.println(to.getKey());
            pw.println("-------------------------------------");
            for (ServiceReference<FileOptimizer> fo : to.getValue()) {
                FileOptimizer o = (FileOptimizer)this.getBundleContext().getService(fo);
                pw.println("- " + o.getName() + " (" + o.getClass().getName() + ")");
            }
        }
        pw.println("</pre>");
        pw.println("</div>");
    }
}

