/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.scheduling;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.event.impl.jobs.scheduling.JobSchedulerImpl;
import org.apache.sling.event.impl.support.ScheduleInfoImpl;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.apache.sling.event.jobs.ScheduledJobInfo;

public class ScheduledJobInfoImpl
implements ScheduledJobInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String scheduleName;
    private final JobSchedulerImpl jobScheduler;
    private final AtomicBoolean isSuspended = new AtomicBoolean(false);
    private volatile List<ScheduleInfo> scheduleInfos;
    private volatile String jobTopic;
    private volatile Map<String, Object> jobProperties;

    public ScheduledJobInfoImpl(JobSchedulerImpl jobScheduler, String scheduleName) {
        this.jobScheduler = jobScheduler;
        this.scheduleName = scheduleName;
    }

    public void update(String jobTopic, Map<String, Object> jobProperties) {
        boolean isSuspended = jobProperties.remove("slingevent:scheduleSuspended") != null;
        List scheduleInfos = (List)jobProperties.remove("slingevent:scheduleInfo");
        this.jobTopic = jobTopic;
        this.jobProperties = jobProperties;
        this.scheduleInfos = Collections.unmodifiableList(scheduleInfos);
        this.isSuspended.set(isSuspended);
    }

    public void update(List<ScheduleInfo> scheduleInfos) {
        this.scheduleInfos = Collections.unmodifiableList(scheduleInfos);
    }

    public String getName() {
        return this.scheduleName;
    }

    @Override
    public Collection<ScheduleInfo> getSchedules() {
        return this.scheduleInfos;
    }

    @Override
    public Date getNextScheduledExecution() {
        Date result = null;
        for (ScheduleInfo info : this.scheduleInfos) {
            Date newResult = ((ScheduleInfoImpl)info).getNextScheduledExecution();
            if (result != null && result.getTime() <= newResult.getTime()) continue;
            result = newResult;
        }
        return result;
    }

    @Override
    public String getJobTopic() {
        return this.jobTopic;
    }

    @Override
    public Map<String, Object> getJobProperties() {
        return this.jobProperties;
    }

    @Override
    public void unschedule() {
        this.jobScheduler.removeJob(this);
    }

    @Override
    public JobBuilder.ScheduleBuilder reschedule() {
        return this.jobScheduler.createJobBuilder(this);
    }

    @Override
    public void suspend() {
        if (this.isSuspended.compareAndSet(false, true)) {
            this.jobScheduler.setSuspended(this, true);
        }
    }

    @Override
    public void resume() {
        if (this.isSuspended.compareAndSet(true, false)) {
            this.jobScheduler.setSuspended(this, false);
        }
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended.get();
    }

    public String getSchedulerJobId() {
        return Job.class.getName() + ":" + this.scheduleName;
    }
}

