/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ResourceSemaphore;
import org.apache.ratis.util.SizeInBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingRequests {
    public static final Logger LOG = LoggerFactory.getLogger(PendingRequests.class);
    private static final int ONE_MB = SizeInBytes.ONE_MB.getSizeInt();
    private PendingRequest pendingSetConf;
    private final String name;
    private final RequestMap pendingRequests;

    static int roundUpMb(long bytes) {
        return Math.toIntExact((bytes - 1L) / (long)ONE_MB + 1L);
    }

    PendingRequests(RaftGroupMemberId id, RaftProperties properties, RaftServerMetricsImpl raftServerMetrics) {
        this.name = id + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.pendingRequests = new RequestMap(id, RaftServerConfigKeys.Write.elementLimit(properties), Math.toIntExact(RaftServerConfigKeys.Write.byteLimit(properties).getSize() / SizeInBytes.ONE_MB.getSize()), raftServerMetrics);
    }

    Permit tryAcquire(Message message) {
        return this.pendingRequests.tryAcquire(message);
    }

    PendingRequest add(Permit permit, RaftClientRequest request, TransactionContext entry) {
        long index = entry.getLogEntry().getIndex();
        LOG.debug("{}: addPendingRequest at index={}, request={}", this.name, index, request);
        PendingRequest pending = new PendingRequest(index, request, entry);
        return this.pendingRequests.put(permit, index, pending);
    }

    PendingRequest addConfRequest(SetConfigurationRequest request) {
        Preconditions.assertTrue(this.pendingSetConf == null);
        this.pendingSetConf = new PendingRequest(request);
        return this.pendingSetConf;
    }

    void replySetConfiguration(Function<RaftClientRequest, RaftClientReply> newSuccessReply) {
        if (this.pendingSetConf != null) {
            RaftClientRequest request = this.pendingSetConf.getRequest();
            LOG.debug("{}: sends success for {}", (Object)this.name, (Object)request);
            this.pendingSetConf.setReply(newSuccessReply.apply(request));
            this.pendingSetConf = null;
        }
    }

    void failSetConfiguration(RaftException e) {
        Preconditions.assertTrue(this.pendingSetConf != null);
        this.pendingSetConf.setException(e);
        this.pendingSetConf = null;
    }

    TransactionContext getTransactionContext(long index) {
        PendingRequest pendingRequest = this.pendingRequests.get(index);
        return pendingRequest != null ? pendingRequest.getEntry() : null;
    }

    void replyPendingRequest(long index, RaftClientReply reply) {
        PendingRequest pending = this.pendingRequests.remove(index);
        if (pending != null) {
            Preconditions.assertTrue(pending.getIndex() == index);
            pending.setReply(reply);
        }
    }

    Collection<TransactionContext> sendNotLeaderResponses(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        LOG.info("{}: sendNotLeaderResponses", (Object)this.name);
        Collection<TransactionContext> transactions = this.pendingRequests.setNotLeaderException(nle, commitInfos);
        if (this.pendingSetConf != null) {
            this.pendingSetConf.setNotLeaderException(nle, commitInfos);
        }
        return transactions;
    }

    void close() {
        if (this.pendingRequests != null) {
            this.pendingRequests.close();
        }
    }

    private static class RequestMap {
        private final Object name;
        private final ConcurrentMap<Long, PendingRequest> map = new ConcurrentHashMap<Long, PendingRequest>();
        private final RaftServerMetricsImpl raftServerMetrics;
        private final Map<Permit, Permit> permits = new HashMap<Permit, Permit>();
        private final RequestLimits resource;
        private final AtomicLong requestSize = new AtomicLong();

        RequestMap(Object name, int elementLimit, int megabyteLimit, RaftServerMetricsImpl raftServerMetrics) {
            this.name = name;
            this.resource = new RequestLimits(elementLimit, megabyteLimit);
            this.raftServerMetrics = raftServerMetrics;
            raftServerMetrics.addNumPendingRequestsGauge(() -> this.resource.getElementCount());
            raftServerMetrics.addNumPendingRequestsMegaByteSize(() -> this.resource.getMegaByteSize());
        }

        Permit tryAcquire(Message message) {
            int messageSize = Message.getSize(message);
            int messageSizeMb = PendingRequests.roundUpMb(messageSize);
            Acquired acquired = this.resource.tryAcquire(messageSizeMb);
            LOG.trace("tryAcquire {} MB? {}", (Object)messageSizeMb, (Object)acquired);
            if (acquired == Acquired.FAILED_IN_ELEMENT_LIMIT) {
                this.raftServerMetrics.onRequestQueueLimitHit();
                this.raftServerMetrics.onResourceLimitHit();
                return null;
            }
            if (acquired == Acquired.FAILED_IN_BYTE_SIZE_LIMIT) {
                this.raftServerMetrics.onRequestByteSizeLimitHit();
                this.raftServerMetrics.onResourceLimitHit();
                return null;
            }
            long oldSize = this.requestSize.getAndAdd(messageSize);
            long newSize = oldSize + (long)messageSize;
            int diffMb = PendingRequests.roundUpMb(newSize) - PendingRequests.roundUpMb(oldSize);
            if (messageSizeMb > diffMb) {
                this.resource.releaseExtraMb(messageSizeMb - diffMb);
            }
            return this.putPermit();
        }

        private synchronized Permit putPermit() {
            if (this.resource.isClosed()) {
                return null;
            }
            Permit permit = new Permit();
            this.permits.put(permit, permit);
            return permit;
        }

        synchronized PendingRequest put(Permit permit, long index, PendingRequest p) {
            LOG.debug("{}: PendingRequests.put {} -> {}", this.name, index, p);
            Permit removed = this.permits.remove(permit);
            if (removed == null) {
                return null;
            }
            Preconditions.assertTrue(removed == permit);
            PendingRequest previous = this.map.put(index, p);
            Preconditions.assertTrue(previous == null);
            return p;
        }

        PendingRequest get(long index) {
            PendingRequest r = (PendingRequest)this.map.get(index);
            LOG.debug("{}: PendingRequests.get {} returns {}", this.name, index, r);
            return r;
        }

        PendingRequest remove(long index) {
            PendingRequest r = (PendingRequest)this.map.remove(index);
            LOG.debug("{}: PendingRequests.remove {} returns {}", this.name, index, r);
            if (r == null) {
                return null;
            }
            int messageSize = Message.getSize(r.getRequest().getMessage());
            long oldSize = this.requestSize.getAndAdd(-messageSize);
            long newSize = oldSize - (long)messageSize;
            int diffMb = PendingRequests.roundUpMb(oldSize) - PendingRequests.roundUpMb(newSize);
            this.resource.release(diffMb);
            LOG.trace("release {} MB", (Object)diffMb);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<TransactionContext> setNotLeaderException(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
            RequestMap requestMap = this;
            synchronized (requestMap) {
                this.resource.close();
                this.permits.clear();
            }
            LOG.debug("{}: PendingRequests.setNotLeaderException", this.name);
            ArrayList<TransactionContext> transactions = new ArrayList<TransactionContext>(this.map.size());
            Iterator i;
            while ((i = this.map.keySet().iterator()).hasNext()) {
                PendingRequest pending = (PendingRequest)this.map.remove(i.next());
                if (pending == null) continue;
                transactions.add(pending.setNotLeaderException(nle, commitInfos));
            }
            return transactions;
        }

        void close() {
            if (this.raftServerMetrics != null) {
                this.raftServerMetrics.removeNumPendingRequestsGauge();
                this.raftServerMetrics.removeNumPendingRequestsByteSize();
            }
        }
    }

    static class RequestLimits
    extends ResourceSemaphore.Group {
        RequestLimits(int elementLimit, int megabyteLimit) {
            super(elementLimit, megabyteLimit);
        }

        int getElementCount() {
            return this.get(0).used();
        }

        int getMegaByteSize() {
            return this.get(1).used();
        }

        Acquired tryAcquire(int messageSizeMb) {
            int acquired = this.tryAcquire(1, messageSizeMb);
            return acquired == -1 ? Acquired.SUCCESS : Acquired.values()[acquired];
        }

        void releaseExtraMb(int extraMb) {
            this.release(0, extraMb);
        }

        void release(int diffMb) {
            this.release(1, diffMb);
        }
    }

    static enum Acquired {
        FAILED_IN_ELEMENT_LIMIT,
        FAILED_IN_BYTE_SIZE_LIMIT,
        SUCCESS;

    }

    static class Permit {
        Permit() {
        }
    }
}

