/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.client;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.ratis.conf.ConfUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RaftClientConfigKeys {
    public static final Logger LOG = LoggerFactory.getLogger(RaftClientConfigKeys.class);
    public static final String PREFIX = "raft.client";

    public static Consumer<String> getDefaultLog() {
        return LOG::debug;
    }

    public static void main(String[] args) {
        ConfUtils.printAll(RaftClientConfigKeys.class);
    }

    public static interface MessageStream {
        public static final String PREFIX = "raft.client.message-stream";
        public static final String SUBMESSAGE_SIZE_KEY = "raft.client.message-stream.submessage-size";
        public static final SizeInBytes SUBMESSAGE_SIZE_DEFAULT = SizeInBytes.valueOf("1MB");

        public static SizeInBytes submessageSize(RaftProperties properties) {
            return ConfUtils.getSizeInBytes(properties::getSizeInBytes, SUBMESSAGE_SIZE_KEY, SUBMESSAGE_SIZE_DEFAULT, RaftClientConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setSubmessageSize(RaftProperties properties, SizeInBytes submessageSize) {
            ConfUtils.setSizeInBytes(properties::set, SUBMESSAGE_SIZE_KEY, submessageSize, ConfUtils.requireMin(SizeInBytes.ONE_KB));
        }

        public static void setSubmessageSize(RaftProperties properties) {
            MessageStream.setSubmessageSize(properties, SUBMESSAGE_SIZE_DEFAULT);
        }
    }

    public static interface DataStream {
        public static final String PREFIX = "raft.client.data-stream";
        public static final String OUTSTANDING_REQUESTS_MAX_KEY = "raft.client.data-stream.outstanding-requests.max";
        public static final int OUTSTANDING_REQUESTS_MAX_DEFAULT = 100;
        public static final String FLUSH_REQUEST_COUNT_MIN_KEY = "raft.client.data-stream.flush.request.count.min";
        public static final int FLUSH_REQUEST_COUNT_MIN_DEFAULT = 0;
        public static final String FLUSH_REQUEST_BYTES_MIN_KEY = "raft.client.data-stream.flush.request.bytes.min";
        public static final SizeInBytes FLUSH_REQUEST_BYTES_MIN_DEFAULT = SizeInBytes.ONE_MB;
        public static final String REQUEST_TIMEOUT_KEY = "raft.client.data-stream.request.timeout";
        public static final TimeDuration REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf(10000L, TimeUnit.MILLISECONDS);

        public static int outstandingRequestsMax(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, OUTSTANDING_REQUESTS_MAX_KEY, 100, RaftClientConfigKeys.getDefaultLog(), ConfUtils.requireMin(2));
        }

        public static void setOutstandingRequestsMax(RaftProperties properties, int outstandingRequests) {
            ConfUtils.setInt(properties::setInt, OUTSTANDING_REQUESTS_MAX_KEY, outstandingRequests, new BiConsumer[0]);
        }

        public static int flushRequestCountMin(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, FLUSH_REQUEST_COUNT_MIN_KEY, 0, RaftClientConfigKeys.getDefaultLog(), ConfUtils.requireMin(0));
        }

        public static void setFlushRequestCountMin(RaftProperties properties, int flushRequestCountMin) {
            ConfUtils.setInt(properties::setInt, FLUSH_REQUEST_COUNT_MIN_KEY, flushRequestCountMin, new BiConsumer[0]);
        }

        public static SizeInBytes flushRequestBytesMin(RaftProperties properties) {
            return ConfUtils.getSizeInBytes(properties::getSizeInBytes, FLUSH_REQUEST_BYTES_MIN_KEY, FLUSH_REQUEST_BYTES_MIN_DEFAULT, RaftClientConfigKeys.getDefaultLog(), ConfUtils.requireMinSizeInByte(SizeInBytes.ZERO));
        }

        public static void setFlushRequestBytesMin(RaftProperties properties, SizeInBytes flushRequestBytesMin) {
            ConfUtils.setSizeInBytes(properties::set, FLUSH_REQUEST_BYTES_MIN_KEY, flushRequestBytesMin, new BiConsumer[0]);
        }

        public static TimeDuration requestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(REQUEST_TIMEOUT_DEFAULT.getUnit()), REQUEST_TIMEOUT_KEY, REQUEST_TIMEOUT_DEFAULT, RaftClientConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, REQUEST_TIMEOUT_KEY, timeoutDuration, new BiConsumer[0]);
        }
    }

    public static interface Async {
        public static final String PREFIX = "raft.client.async";
        public static final String OUTSTANDING_REQUESTS_MAX_KEY = "raft.client.async.outstanding-requests.max";
        public static final int OUTSTANDING_REQUESTS_MAX_DEFAULT = 100;

        public static int outstandingRequestsMax(RaftProperties properties) {
            return ConfUtils.getInt(properties::getInt, OUTSTANDING_REQUESTS_MAX_KEY, 100, RaftClientConfigKeys.getDefaultLog(), ConfUtils.requireMin(2));
        }

        public static void setOutstandingRequestsMax(RaftProperties properties, int outstandingRequests) {
            ConfUtils.setInt(properties::setInt, OUTSTANDING_REQUESTS_MAX_KEY, outstandingRequests, new BiConsumer[0]);
        }

        public static interface Experimental {
            public static final String PREFIX = "raft.client.async." + JavaUtils.getClassSimpleName(Experimental.class).toLowerCase();
            public static final String SEND_DUMMY_REQUEST_KEY = PREFIX + ".send-dummy-request";
            public static final boolean SEND_DUMMY_REQUEST_DEFAULT = true;

            public static boolean sendDummyRequest(RaftProperties properties) {
                return ConfUtils.getBoolean(properties::getBoolean, SEND_DUMMY_REQUEST_KEY, true, RaftClientConfigKeys.getDefaultLog(), new BiConsumer[0]);
            }

            public static void setSendDummyRequest(RaftProperties properties, boolean sendDummyRequest) {
                ConfUtils.setBoolean(properties::setBoolean, SEND_DUMMY_REQUEST_KEY, sendDummyRequest, new BiConsumer[0]);
            }
        }
    }

    public static interface Rpc {
        public static final String PREFIX = "raft.client.rpc";
        public static final String REQUEST_TIMEOUT_KEY = "raft.client.rpc.request.timeout";
        public static final TimeDuration REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf(3000L, TimeUnit.MILLISECONDS);
        public static final String WATCH_REQUEST_TIMEOUT_KEY = "raft.client.rpc.watch.request.timeout";
        public static final TimeDuration WATCH_REQUEST_TIMEOUT_DEFAULT = TimeDuration.valueOf(10000L, TimeUnit.MILLISECONDS);

        public static TimeDuration requestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(REQUEST_TIMEOUT_DEFAULT.getUnit()), REQUEST_TIMEOUT_KEY, REQUEST_TIMEOUT_DEFAULT, RaftClientConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, REQUEST_TIMEOUT_KEY, timeoutDuration, new BiConsumer[0]);
        }

        public static TimeDuration watchRequestTimeout(RaftProperties properties) {
            return ConfUtils.getTimeDuration(properties.getTimeDuration(WATCH_REQUEST_TIMEOUT_DEFAULT.getUnit()), WATCH_REQUEST_TIMEOUT_KEY, WATCH_REQUEST_TIMEOUT_DEFAULT, RaftClientConfigKeys.getDefaultLog(), new BiConsumer[0]);
        }

        public static void setWatchRequestTimeout(RaftProperties properties, TimeDuration timeoutDuration) {
            ConfUtils.setTimeDuration(properties::setTimeDuration, WATCH_REQUEST_TIMEOUT_KEY, timeoutDuration, new BiConsumer[0]);
        }
    }
}

