/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.KeyStoreMessages;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.security.CertificateDetails;
import org.apache.qpid.server.security.CertificateDetailsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyStore<X extends AbstractKeyStore<X>>
extends AbstractConfiguredObject<X>
implements KeyStore<X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractKeyStore.class);
    protected static final long ONE_DAY = 86400000L;
    private final Broker<?> _broker;
    private final EventLogger _eventLogger;
    private ScheduledFuture<?> _checkExpiryTaskFuture;

    public AbstractKeyStore(Map<String, Object> attributes, Broker<?> broker) {
        super(broker, attributes);
        this._broker = broker;
        this._eventLogger = broker.getEventLogger();
    }

    public final Broker<?> getBroker() {
        return this._broker;
    }

    final EventLogger getEventLogger() {
        return this._eventLogger;
    }

    @Override
    protected ListenableFuture<Void> onClose() {
        this.onCloseOrDelete();
        return Futures.immediateFuture(null);
    }

    private void onCloseOrDelete() {
        if (this._checkExpiryTaskFuture != null) {
            this._checkExpiryTaskFuture.cancel(false);
            this._checkExpiryTaskFuture = null;
        }
    }

    @Override
    protected void logOperation(String operation) {
        this._eventLogger.message(KeyStoreMessages.OPERATION(operation));
    }

    protected void initializeExpiryChecking() {
        int checkFrequency = this.getCertificateExpiryCheckFrequency();
        if (this.getBroker().getState() == State.ACTIVE) {
            this._checkExpiryTaskFuture = this.getBroker().scheduleHouseKeepingTask(checkFrequency, TimeUnit.DAYS, this::checkCertificateExpiry);
        } else {
            final int frequency = checkFrequency;
            this.getBroker().addChangeListener(new AbstractConfigurationChangeListener(){

                @Override
                public void stateChanged(ConfiguredObject<?> object, State oldState, State newState) {
                    if (newState == State.ACTIVE) {
                        AbstractKeyStore.this._checkExpiryTaskFuture = AbstractKeyStore.this.getBroker().scheduleHouseKeepingTask(frequency, TimeUnit.DAYS, () -> AbstractKeyStore.this.checkCertificateExpiry());
                        AbstractKeyStore.this.getBroker().removeChangeListener(this);
                    }
                }
            });
        }
    }

    protected abstract void checkCertificateExpiry();

    protected void checkCertificatesExpiry(long currentTime, Date expiryTestDate, X509Certificate[] chain) {
        if (chain != null) {
            for (X509Certificate cert : chain) {
                try {
                    cert.checkValidity(expiryTestDate);
                }
                catch (CertificateExpiredException e) {
                    long timeToExpiry = cert.getNotAfter().getTime() - currentTime;
                    int days = Math.max(0, (int)(timeToExpiry / 86400000L));
                    this.getEventLogger().message(KeyStoreMessages.EXPIRING(this.getName(), String.valueOf(days), cert.getSubjectDN().toString()));
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected ListenableFuture<Void> onDelete() {
        this.onCloseOrDelete();
        return super.onDelete();
    }

    @Override
    public final int getCertificateExpiryWarnPeriod() {
        try {
            return this.getContextValue(Integer.class, "qpid.keystore.certificateExpiryWarnPeriod");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOGGER.warn("The value of the context variable '{}' for keystore {} cannot be converted to an integer. The value {} will be used as a default", new Object[]{"qpid.keystore.certificateExpiryWarnPeriod", this.getName(), 30});
            return 30;
        }
    }

    @Override
    public int getCertificateExpiryCheckFrequency() {
        int checkFrequency;
        try {
            checkFrequency = this.getContextValue(Integer.class, "qpid.keystore.certificateExpiryCheckFrequency");
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOGGER.warn("Cannot parse the context variable {} ", (Object)"qpid.keystore.certificateExpiryCheckFrequency", (Object)e);
            checkFrequency = 1;
        }
        return checkFrequency;
    }

    @Override
    public List<CertificateDetails> getCertificateDetails() {
        Collection<Certificate> certificates = this.getCertificates();
        if (!certificates.isEmpty()) {
            return certificates.stream().filter(cert -> cert instanceof X509Certificate).map(x509cert -> new CertificateDetailsImpl((X509Certificate)x509cert)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected abstract Collection<Certificate> getCertificates();

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        this._eventLogger.message(KeyStoreMessages.CREATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    @Override
    protected void logRecovered(Outcome outcome) {
        this._eventLogger.message(KeyStoreMessages.OPEN(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        this._eventLogger.message(KeyStoreMessages.DELETE(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logUpdated(Map<String, Object> attributes, Outcome outcome) {
        this._eventLogger.message(KeyStoreMessages.UPDATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }
}

