/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.protocol.LinkModel;
import org.apache.qpid.server.protocol.v1_0.AbstractLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.ErrantLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.LinkDefinition;
import org.apache.qpid.server.protocol.v1_0.LinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.LinkRegistry;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.SendingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.Session_1_0;
import org.apache.qpid.server.protocol.v1_0.StandardReceivingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.TxnCoordinatorReceivingLinkEndpoint;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.transaction.Coordinator;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.LinkError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkImpl<S extends BaseSource, T extends BaseTarget>
implements Link_1_0<S, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkImpl.class);
    private final String _remoteContainerId;
    private final String _linkName;
    private final Role _role;
    private final LinkRegistry<S, T> _linkRegistry;
    private final Queue<ThiefInformation> _thiefQueue = new LinkedList<ThiefInformation>();
    private volatile LinkEndpoint<S, T> _linkEndpoint;
    private volatile S _source;
    private volatile T _target;
    private boolean _stealingInProgress;
    private final Queue<Action<? super Link_1_0<S, T>>> _deleteTasks = new ConcurrentLinkedQueue<Action<? super Link_1_0<S, T>>>();

    public LinkImpl(String remoteContainerId, String linkName, Role role, LinkRegistry<S, T> linkRegistry) {
        this._remoteContainerId = remoteContainerId;
        this._linkName = linkName;
        this._role = role;
        this._linkRegistry = linkRegistry;
    }

    public LinkImpl(LinkDefinition<S, T> linkDefinition, LinkRegistry<S, T> linkRegistry) {
        this(linkDefinition.getRemoteContainerId(), linkDefinition.getName(), linkDefinition.getRole(), linkRegistry);
        this.setTermini(linkDefinition.getSource(), linkDefinition.getTarget());
    }

    @Override
    public final synchronized ListenableFuture<? extends LinkEndpoint<S, T>> attach(Session_1_0 session, Attach attach) {
        try {
            if (this._role == attach.getRole()) {
                throw new AmqpErrorException(new Error(AmqpError.ILLEGAL_STATE, "Cannot switch SendingLink to ReceivingLink and vice versa"));
            }
            if (this._linkEndpoint != null && !((Object)((Object)session)).equals((Object)this._linkEndpoint.getSession())) {
                if (!Objects.equals(this._linkEndpoint.getSession().getConnection().getPrincipal(), session.getConnection().getPrincipal())) {
                    Operation operation = attach.getRole() == Role.SENDER ? Operation.PERFORM_ACTION((String)"publish") : Operation.PERFORM_ACTION((String)"consume");
                    ConfiguredObject targetObject = this._linkEndpoint instanceof SendingLinkEndpoint ? (ConfiguredObject)((SendingLinkEndpoint)this._linkEndpoint).getDestination().getMessageSource() : (ConfiguredObject)session.getReceivingDestination(this, (Target)this.getTarget()).getMessageDestination();
                    targetObject.authorise(operation);
                }
                SettableFuture future = SettableFuture.create();
                this._thiefQueue.add(new ThiefInformation(session, attach, future));
                this.startLinkStealingIfNecessary();
                return future;
            }
            if (this._linkEndpoint == null) {
                this._linkEndpoint = this.createLinkEndpoint(session, attach);
            }
            this._linkEndpoint.receiveAttach(attach);
            this._linkRegistry.linkChanged(this);
            return Futures.immediateFuture(this._linkEndpoint);
        }
        catch (Exception e) {
            LOGGER.debug("Error attaching link", (Throwable)e);
            return this.rejectLink(session, e);
        }
    }

    @Override
    public synchronized void linkClosed() {
        Iterator iterator = this._deleteTasks.iterator();
        while (iterator.hasNext()) {
            Action deleteTask = (Action)iterator.next();
            deleteTask.performAction((Object)this);
            iterator.remove();
        }
        this.discardEndpoint();
        this._linkRegistry.linkClosed(this);
    }

    @Override
    public synchronized void discardEndpoint() {
        this._linkEndpoint = null;
    }

    @Override
    public final String getName() {
        return this._linkName;
    }

    @Override
    public Role getRole() {
        return this._role;
    }

    @Override
    public S getSource() {
        return this._source;
    }

    @Override
    public void setSource(S source) {
        this.setTermini(source, this._target);
    }

    @Override
    public T getTarget() {
        return this._target;
    }

    @Override
    public void setTarget(T target) {
        this.setTermini(this._source, target);
    }

    @Override
    public void setTermini(S source, T target) {
        this._source = source;
        this._target = target;
    }

    @Override
    public TerminusDurability getHighestSupportedTerminusDurability() {
        return this._linkRegistry.getHighestSupportedTerminusDurability();
    }

    @Override
    public String getRemoteContainerId() {
        return this._remoteContainerId;
    }

    private LinkEndpoint<S, T> createLinkEndpoint(Session_1_0 session, Attach attach) {
        AbstractLinkEndpoint linkEndpoint = this._role == Role.SENDER ? new SendingLinkEndpoint(session, this) : (attach.getTarget() instanceof Coordinator ? new TxnCoordinatorReceivingLinkEndpoint(session, this) : new StandardReceivingLinkEndpoint(session, this));
        return linkEndpoint;
    }

    private ListenableFuture<? extends LinkEndpoint<S, T>> rejectLink(Session_1_0 session, Throwable t) {
        this._linkEndpoint = t instanceof AmqpErrorException ? new ErrantLinkEndpoint(this, session, ((AmqpErrorException)t).getError()) : new ErrantLinkEndpoint(this, session, new Error(AmqpError.INTERNAL_ERROR, t.getMessage()));
        return Futures.immediateFuture(this._linkEndpoint);
    }

    private void startLinkStealingIfNecessary() {
        if (!this._stealingInProgress) {
            this._stealingInProgress = true;
            this.stealLink();
        }
    }

    private synchronized void stealLink() {
        final ThiefInformation thiefInformation = this._thiefQueue.poll();
        if (thiefInformation != null) {
            AbstractConfiguredObject.addFutureCallback(this.doStealLink(thiefInformation.getSession(), thiefInformation.getAttach()), (FutureCallback)new FutureCallback<LinkEndpoint<S, T>>(){

                public void onSuccess(LinkEndpoint<S, T> result) {
                    thiefInformation.getFuture().set(result);
                    LinkImpl.this.stealLink();
                }

                public void onFailure(Throwable t) {
                    thiefInformation.getFuture().setException(t);
                    LinkImpl.this.stealLink();
                }
            }, (Executor)MoreExecutors.directExecutor());
        } else {
            this._stealingInProgress = false;
        }
    }

    private ListenableFuture<LinkEndpoint<S, T>> doStealLink(Session_1_0 session, Attach attach) {
        SettableFuture returnFuture = SettableFuture.create();
        LinkEndpoint<S, T> linkEndpoint = this._linkEndpoint;
        if (linkEndpoint != null) {
            linkEndpoint.getSession().doOnIOThreadAsync(() -> {
                LinkEndpoint<S, T> endpoint = this._linkEndpoint;
                if (endpoint != null) {
                    endpoint.close(new Error(LinkError.STOLEN, String.format("Link is being stolen by connection '%s'", session.getConnection())));
                }
                this.doLinkStealAndHandleExceptions(session, attach, returnFuture);
            });
        } else {
            this.doLinkStealAndHandleExceptions(session, attach, returnFuture);
        }
        return returnFuture;
    }

    private void doLinkStealAndHandleExceptions(Session_1_0 session, Attach attach, SettableFuture<LinkEndpoint<S, T>> returnFuture) {
        try {
            returnFuture.set((Object)((LinkEndpoint)this.attach(session, attach).get()));
        }
        catch (InterruptedException e) {
            returnFuture.setException((Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            returnFuture.setException(e.getCause());
        }
    }

    public void addDeleteTask(Action<? super LinkModel> task) {
        this._deleteTasks.add(task);
    }

    public void removeDeleteTask(Action<? super LinkModel> task) {
        this._deleteTasks.remove(task);
    }

    private class ThiefInformation {
        private final Session_1_0 _session;
        private final Attach _attach;
        private final SettableFuture<LinkEndpoint<S, T>> _future;

        ThiefInformation(Session_1_0 session, Attach attach, SettableFuture<LinkEndpoint<S, T>> future) {
            this._session = session;
            this._attach = attach;
            this._future = future;
        }

        Session_1_0 getSession() {
            return this._session;
        }

        Attach getAttach() {
            return this._attach;
        }

        SettableFuture<LinkEndpoint<S, T>> getFuture() {
            return this._future;
        }
    }
}

