/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.gui.widget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.tp23.gui.widget.SelectFileAction;

public class FollowingJTextArea
extends JTextArea {
    private boolean follow = true;

    public FollowingJTextArea() {
        this.jInit();
    }

    private void jInit() {
        final JPopupMenu popUp = this.getPopupMenu();
        this.add(popUp);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    popUp.show(FollowingJTextArea.this, e.getX(), e.getY());
                }
            }
        });
    }

    public boolean isFollow() {
        return this.follow;
    }

    public void setFollow(boolean follow) {
        this.follow = follow;
    }

    private void scrollToEnd() {
        this.setCaretPosition(this.getDocument().getLength());
    }

    private void toggleFollow() {
        this.setFollow(!this.isFollow());
    }

    public void append(String str) {
        super.append(str);
        if (this.follow) {
            this.scrollToEnd();
        }
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu contextMenu = new JPopupMenu("Options");
        JMenuItem saveMenu = new JMenuItem("Save Text");
        saveMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SelectFileAction action = new SelectFileAction("Save Output", null, null);
                try {
                    action.actionPerformed(new ActionEvent(this, 0, "Save Output"));
                    if (action.selectedFile != null) {
                        FileWriter fos = new FileWriter(action.selectedFile);
                        fos.write(FollowingJTextArea.this.getText());
                        fos.close();
                    }
                }
                catch (FileNotFoundException ex) {
                    System.err.println("FileNotFoundException");
                }
                catch (IOException ex) {
                    System.err.println("IOException");
                }
            }
        });
        contextMenu.add(saveMenu);
        JMenuItem toggleFollowMenu = new JMenuItem("Toggle Follow");
        toggleFollowMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FollowingJTextArea.this.toggleFollow();
            }
        });
        contextMenu.add(toggleFollowMenu);
        JMenuItem jumpToEndMenu = new JMenuItem("Jump To End");
        jumpToEndMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FollowingJTextArea.this.setCaretPosition(FollowingJTextArea.this.getDocument().getLength());
            }
        });
        contextMenu.add(toggleFollowMenu);
        JMenuItem clearTextMenu = new JMenuItem("Clear Text");
        clearTextMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FollowingJTextArea.this.setText("");
            }
        });
        contextMenu.add(clearTextMenu);
        return contextMenu;
    }
}

