/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.input.SelectInput;
import org.tp23.antinstaller.renderer.text.TextOutputFieldRenderer;

public class SelectInputRenderer
implements TextOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.text.Res");
    protected InstallerContext ctx;

    public void setContext(InstallerContext ctx) {
        this.ctx = ctx;
    }

    public void renderOutput(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        SelectInput iField = (SelectInput)field;
        this.printText(iField, out);
        String input = reader.readLine();
        out.println();
        if (input == null || input.equals("")) {
            input = iField.getDefaultValue();
        } else {
            try {
                int idx = Integer.parseInt(input.trim());
                input = iField.getOptions()[idx - 1].value;
            }
            catch (Exception numFormatOrIndexOutOfBounds) {
                return;
            }
        }
        iField.setInputResult(input);
    }

    public boolean isAbort() {
        return false;
    }

    private void printText(SelectInput iField, PrintStream out) throws IOException {
        out.println(iField.getDisplayText());
        SelectInput.Option[] options = iField.getOptions();
        out.print("  ");
        out.println(res.getString("enterNumber"));
        for (int i = 0; i < options.length; ++i) {
            out.print("  ");
            out.print(i + 1);
            out.print(") ");
            out.print(options[i].getText());
            if (iField.getDefaultValue().equals(options[i].value)) {
                out.print(" [");
                out.print(res.getString("_default_"));
                out.print("]");
            }
            out.println();
        }
    }

    public void renderError(OutputField field, BufferedReader reader, PrintStream out) throws IOException {
        this.ctx.getMessageRenderer().printMessage("Not a valid selection");
        this.renderOutput(field, reader, out);
    }
}

