/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.FileInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.MessageRenderer;
import org.tp23.antinstaller.renderer.swing.AIButton;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.AIShortTextField;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;

public class FileInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    protected FileInput inputField;
    protected AILabel fieldLabel = new AILabel();
    protected AIShortTextField jTextField = new AIShortTextField();
    protected AIButton browseButton = new AIButton();
    protected JPanel browsePanel = new JPanel();
    private Color origFore = this.jTextField.getForeground();
    private JPanel parent;

    public void initComponent(JPanel parent) {
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOutputField(OutputField inputField) {
        this.inputField = (FileInput)inputField;
        this.inputField.setValue(this.inputField.getDefaultValue(true));
    }

    public void updateInputField() {
        if (!this.inputField.getDefaultValue(true).equals(this.jTextField.getText())) {
            this.inputField.setEditted(true);
        }
        this.inputField.setValue(this.jTextField.getText());
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            this.jTextField.setText(this.inputField.getDefaultValue(true));
        }
    }

    private void jbInit() throws Exception {
        BorderLayout bl = new BorderLayout();
        this.browsePanel.setLayout(bl);
        this.fieldLabel.setText(this.inputField.getDisplayText());
        this.jTextField.setText(this.inputField.getDefaultValue(true));
        this.browsePanel.add((Component)this.jTextField, "Center");
        this.browsePanel.add((Component)this.browseButton, "East");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                File selectedFile = null;
                JFileChooser chooser = new JFileChooser();
                chooser.setFileHidingEnabled(false);
                chooser.setFileSelectionMode(0);
                if (FileInputRenderer.this.jTextField.getText() != null) {
                    chooser.setCurrentDirectory(new File(FileInputRenderer.this.jTextField.getText()).getParentFile());
                }
                if ((returnVal = chooser.showDialog(FileInputRenderer.this.parent, e.getActionCommand())) == 0) {
                    selectedFile = chooser.getSelectedFile();
                }
                if (selectedFile != null) {
                    FileInputRenderer.this.jTextField.setText(selectedFile.getAbsolutePath());
                    FileInputRenderer.this.inputField.setValue(selectedFile.getAbsolutePath());
                    FileInputRenderer.this.inputField.setEditted(true);
                }
            }
        });
        this.browseButton.setText(res.getString("selectFile"));
        this.browseButton.setPreferredSize(new Dimension(150, SizeConstants.FIELD_HEIGHT));
        this.jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileInputRenderer.this.updateInputField();
            }
        });
        this.jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                FileInputRenderer.this.jTextField.setForeground(FileInputRenderer.this.origFore);
            }
        });
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getCell(row, 0));
        content.add((Component)this.browsePanel, cf.getCell(row, 1));
        if (overflow) {
            this.jTextField.setOverflow(SizeConstants.OVERFLOW_SHORT_FIELD_SIZE);
        }
        return ++row;
    }

    public void renderError() {
        MessageRenderer mr = this.ctx.getMessageRenderer();
        mr.printMessage(res.getString("fileNotExist"));
        this.jTextField.requestFocus();
        this.jTextField.setForeground(Color.red);
    }
}

