/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputField;
import org.tp23.antinstaller.input.Target;

public class TargetInput
extends InputField
implements Target {
    private String target;
    private String force;
    private String osSpecific;
    private String strict;
    private int idx = TargetInput.getGlobalIdx();
    private static int globalIdx = 1;

    public String getTarget() {
        if (TargetInput.isTrue(this.osSpecific)) {
            return this.getOSSpecificTarget();
        }
        return this.target;
    }

    public String getTargetName() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        this.setProperty(target);
    }

    public String getForce() {
        return this.force;
    }

    public void setForce(String force) {
        this.force = force;
    }

    public String getStrict() {
        return this.strict;
    }

    public void setStrict(String strict) {
        this.strict = strict;
    }

    public String getOsSpecific() {
        return this.osSpecific;
    }

    public void setOsSpecific(String osSpecific) {
        this.osSpecific = osSpecific;
    }

    public boolean validate(InstallerContext cxt) throws ValidationException {
        return true;
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("Target:displayText must be set");
            return false;
        }
        if (this.getTarget() == null) {
            System.out.println("Target:target must be set");
            return false;
        }
        if (!InputField.optionalBoolean(this.getForce())) {
            System.out.println("Target:force must be true or false or null");
            return false;
        }
        if (!InputField.optionalBoolean(this.getStrict())) {
            System.out.println("Target:strict must be true or false or null");
            return false;
        }
        if (!InputField.optionalBoolean(this.getOsSpecific())) {
            System.out.println("Target:osSpecific must be true or false or null");
            return false;
        }
        if (!InputField.requiredBoolean(this.getDefaultValue())) {
            System.out.println("Target:defaultValue must be true or false");
            return false;
        }
        return true;
    }

    public int getIdx() {
        return this.idx;
    }

    public static int getGlobalIdx() {
        return globalIdx++;
    }

    public String getOSSpecificTarget() {
        if (TargetInput.isTrue(this.strict)) {
            return this.getStrictTarget();
        }
        return this.getLaxTarget();
    }

    private String getStrictTarget() {
        return this.target + TargetInput.getOsSpecificSuffix();
    }

    private String getLaxTarget() {
        return this.target + TargetInput.getLaxOsSpecificSuffix();
    }

    public static String getOsSpecificSuffix() {
        return System.getProperty("os.name");
    }

    public static String getLaxOsSpecificSuffix() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("linux") != -1) {
            return "-linux";
        }
        if (osName.indexOf("mac") != -1) {
            return "-mac";
        }
        if (osName.indexOf("windows") != -1) {
            return "-win";
        }
        if (osName.indexOf("solaris") != -1 || osName.indexOf("sunos") != -1) {
            return "-sun";
        }
        return "-other";
    }
}

