/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class Streams {
    static final int BLOCK_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drain(InputStream r, OutputStream w) throws IOException {
        byte[] bytes = new byte[4096];
        try {
            int length = r.read(bytes);
            while (length != -1) {
                if (length != 0) {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally {
            bytes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drain(Reader r, Writer w) throws IOException {
        char[] bytes = new char[4096];
        try {
            int length = r.read(bytes);
            while (length != -1) {
                if (length != 0) {
                    w.write(bytes, 0, length);
                }
                length = r.read(bytes);
            }
        }
        finally {
            bytes = null;
        }
    }

    public static void drain(Reader r, OutputStream os) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(os);
        Streams.drain(r, (Writer)w);
        ((Writer)w).flush();
    }

    public static void drain(InputStream is, Writer w) throws IOException {
        InputStreamReader r = new InputStreamReader(is);
        Streams.drain((Reader)r, w);
        w.flush();
    }

    public static byte[] drain(InputStream r) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Streams.drain(r, (OutputStream)bytes);
        return bytes.toByteArray();
    }

    public static String getAsString(InputStream is) {
        int offset;
        char[] buf;
        int c;
        block8: {
            char[] lineBuffer;
            c = 0;
            buf = lineBuffer = new char[128];
            int room = buf.length;
            offset = 0;
            try {
                while (true) {
                    c = is.read();
                    switch (c) {
                        case -1: {
                            break block8;
                        }
                        default: {
                            if (--room < 0) {
                                buf = new char[offset + 128];
                                room = buf.length - offset - 1;
                                System.arraycopy(lineBuffer, 0, buf, 0, offset);
                                lineBuffer = buf;
                            }
                            buf[offset++] = (char)c;
                            break;
                        }
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buf, 0, offset);
    }
}

