/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter.html;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.portals.applications.webcontent2.portlet.rewriter.ParserAdaptor;
import org.apache.portals.applications.webcontent2.portlet.rewriter.Rewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterException;
import org.apache.portals.applications.webcontent2.portlet.rewriter.html.SwingAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwingParserAdaptor
implements ParserAdaptor {
    protected static final Logger log = LoggerFactory.getLogger(SwingParserAdaptor.class);
    private Callback callback = null;
    private String lineSeparator = System.getProperty("line.separator", "\r\n");
    private boolean skippingImplied = false;
    private Rewriter rewriter;

    @Override
    public void rewrite(Rewriter rewriter, Reader reader, Writer writer) throws RewriterException {
        try {
            this.rewriter = rewriter;
            HTMLEditorKit.Parser parser = new ParserGetter().getParser();
            this.callback = new Callback(writer);
            parser.parse(reader, this.callback, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RewriterException(e);
        }
    }

    @Override
    public void parse(Rewriter rewriter, Reader reader) throws RewriterException {
        try {
            this.rewriter = rewriter;
            HTMLEditorKit.Parser parser = new ParserGetter().getParser();
            this.callback = new Callback(null);
            parser.parse(reader, this.callback, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RewriterException(e);
        }
    }

    class Callback
    extends HTMLEditorKit.ParserCallback {
        private boolean inForm = false;
        private boolean inScript = false;
        private boolean strip = false;
        private boolean simpleTag = false;
        private String stripTag = null;
        private Writer writer = null;
        private Stack tagStack = new Stack();

        private Callback(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void handleText(char[] values, int param) {
            String tag;
            String convertedValues;
            if (this.strip) {
                return;
            }
            if (values[0] == '>') {
                return;
            }
            if (!SwingParserAdaptor.this.rewriter.enterText(values, param)) {
                return;
            }
            if (!this.tagStack.isEmpty() && (convertedValues = this.convertText(tag = (String)this.tagStack.peek(), new String(values))) != null) {
                values = convertedValues.toCharArray();
            }
            this.addToResult(values);
        }

        private void write(String text) throws IOException {
            if (this.writer != null) {
                this.writer.write(text);
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag htmlTag, MutableAttributeSet attrs, int param) {
            String tag = htmlTag.toString();
            if (!SwingParserAdaptor.this.rewriter.enterSimpleTagEvent(tag, new SwingAttributes(attrs))) {
                return;
            }
            if (this.strip) {
                return;
            }
            if (SwingParserAdaptor.this.rewriter.shouldStripTag(tag)) {
                return;
            }
            if (SwingParserAdaptor.this.rewriter.shouldRemoveTag(tag)) {
                return;
            }
            try {
                this.simpleTag = true;
                this.appendTagToResult(htmlTag, attrs);
                this.write(SwingParserAdaptor.this.lineSeparator);
                this.simpleTag = false;
                String appended = SwingParserAdaptor.this.rewriter.exitSimpleTagEvent(tag, new SwingAttributes(attrs));
                if (null != appended) {
                    this.write(appended);
                }
            }
            catch (Exception e) {
                log.error("Simple tag parsing error", (Throwable)e);
            }
        }

        @Override
        public void handleStartTag(HTML.Tag htmlTag, MutableAttributeSet attrs, int position) {
            String tag = htmlTag.toString();
            this.tagStack.push(tag);
            if (!SwingParserAdaptor.this.rewriter.enterStartTagEvent(tag, new SwingAttributes(attrs))) {
                return;
            }
            if (this.strip) {
                return;
            }
            if (SwingParserAdaptor.this.rewriter.shouldStripTag(tag)) {
                this.stripTag = tag;
                this.strip = true;
                return;
            }
            if (SwingParserAdaptor.this.rewriter.shouldRemoveTag(tag)) {
                return;
            }
            try {
                this.appendTagToResult(htmlTag, attrs);
                this.formatLine(htmlTag);
                String appended = SwingParserAdaptor.this.rewriter.exitStartTagEvent(tag, new SwingAttributes(attrs));
                if (null != appended) {
                    this.write(appended);
                }
            }
            catch (Exception e) {
                log.error("Start tag parsing error", (Throwable)e);
            }
        }

        @Override
        public void handleEndTag(HTML.Tag htmlTag, int position) {
            String tag = htmlTag.toString();
            if (!this.tagStack.isEmpty() && tag.equals(this.tagStack.peek())) {
                this.tagStack.pop();
            }
            if (!SwingParserAdaptor.this.rewriter.enterEndTagEvent(tag.toString())) {
                return;
            }
            if (this.strip) {
                if (tag.equalsIgnoreCase(this.stripTag)) {
                    this.strip = false;
                    this.stripTag = null;
                }
                return;
            }
            if (SwingParserAdaptor.this.rewriter.shouldRemoveTag(tag)) {
                return;
            }
            try {
                this.addToResult("</").addToResult(tag).addToResult(">");
                this.write(SwingParserAdaptor.this.lineSeparator);
                String appended = SwingParserAdaptor.this.rewriter.exitEndTagEvent(tag);
                if (null != appended) {
                    this.write(appended);
                }
            }
            catch (Exception e) {
                log.error("End tag parsing error", (Throwable)e);
            }
        }

        @Override
        public void handleError(String str, int param) {
        }

        @Override
        public void handleComment(char[] values, int param) {
            if (this.strip || SwingParserAdaptor.this.rewriter.shouldRemoveComments()) {
                return;
            }
            this.addToResult("<!-- ").addToResult(values).addToResult(" -->").addToResult(SwingParserAdaptor.this.lineSeparator);
        }

        @Override
        public void handleEndOfLineString(String str) {
            if (this.strip) {
                return;
            }
            this.addToResult(SwingParserAdaptor.this.lineSeparator);
            this.addToResult(str);
        }

        private void formatLine(HTML.Tag tag) {
            try {
                if (tag.isBlock() || tag.breaksFlow() || tag == HTML.Tag.FRAME || tag == HTML.Tag.FRAMESET || tag == HTML.Tag.SCRIPT) {
                    this.write(SwingParserAdaptor.this.lineSeparator);
                }
            }
            catch (Exception e) {
                log.error("Format Line tag parsing error", (Throwable)e);
            }
        }

        private Callback addToResult(Object txt) {
            try {
                this.write(txt.toString());
            }
            catch (Exception e) {
                System.err.println("Error parsing:" + e);
            }
            return this;
        }

        private Callback addToResult(char[] txt) {
            try {
                if (this.writer != null) {
                    this.writer.write(txt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        public void getResult() {
            try {
                if (this.writer != null) {
                    this.writer.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void flush() throws BadLocationException {
        }

        private void appendTagToResult(HTML.Tag tag, MutableAttributeSet attrs) {
            this.convertURLS(tag, attrs);
            Enumeration<?> e = attrs.getAttributeNames();
            this.addToResult("<").addToResult(tag);
            while (e.hasMoreElements()) {
                Object attr = e.nextElement();
                String value = attrs.getAttribute(attr).toString();
                this.addToResult(" ").addToResult(attr).addToResult("=\"").addToResult(value).addToResult("\"");
            }
            if (this.simpleTag) {
                this.addToResult("/>");
            } else {
                this.addToResult(">");
            }
        }

        private void convertURLS(HTML.Tag tag, MutableAttributeSet attrs) {
            SwingParserAdaptor.this.rewriter.enterConvertTagEvent(tag.toString(), new SwingAttributes(attrs));
        }

        private String convertText(String tag, String text) {
            return SwingParserAdaptor.this.rewriter.enterConvertTextEvent(tag.toString(), text);
        }
    }

    class ParserGetter
    extends HTMLEditorKit {
        ParserGetter() {
        }

        @Override
        public HTMLEditorKit.Parser getParser() {
            return super.getParser();
        }
    }
}

