/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter;

import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.apache.portals.applications.webcontent2.portlet.rewriter.MutableAttributes;
import org.apache.portals.applications.webcontent2.portlet.rewriter.ParserAdaptor;
import org.apache.portals.applications.webcontent2.portlet.rewriter.Rewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRewriter
implements Rewriter {
    protected static final Logger log = LoggerFactory.getLogger(AbstractRewriter.class);
    private String baseUrl = null;
    private boolean useProxy = false;

    @Override
    public void parse(ParserAdaptor adaptor, Reader reader) throws RewriterException {
        adaptor.parse(this, reader);
    }

    @Override
    public void rewrite(ParserAdaptor adaptor, Reader reader, Writer writer) throws RewriterException {
        adaptor.rewrite(this, reader, writer);
    }

    @Override
    public abstract String rewriteUrl(String var1, String var2, String var3);

    @Override
    public void setBaseUrl(String base) {
        this.baseUrl = base;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getBaseRelativeUrl(String relativeUrl) {
        try {
            String baseUrl = this.getBaseUrl();
            if (baseUrl != null) {
                URL xlate = new URL(new URL(baseUrl), relativeUrl);
                return xlate.toString();
            }
        }
        catch (Exception e) {
            log.error("Unable to translate URL relative to base URL", (Throwable)e);
        }
        return relativeUrl;
    }

    @Override
    public boolean getUseProxy() {
        return this.useProxy;
    }

    @Override
    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    @Override
    public boolean enterSimpleTagEvent(String tag, MutableAttributes attrs) {
        return true;
    }

    @Override
    public String exitSimpleTagEvent(String tag, MutableAttributes attrs) {
        return null;
    }

    @Override
    public boolean enterStartTagEvent(String tag, MutableAttributes attrs) {
        return true;
    }

    @Override
    public String exitStartTagEvent(String tag, MutableAttributes attrs) {
        return null;
    }

    @Override
    public boolean enterEndTagEvent(String tag) {
        return true;
    }

    @Override
    public String exitEndTagEvent(String tag) {
        return null;
    }

    @Override
    public boolean enterText(char[] values, int param) {
        return true;
    }

    @Override
    public void enterConvertTagEvent(String tag, MutableAttributes attrs) {
    }

    @Override
    public String enterConvertTextEvent(String tag, String text) {
        return null;
    }
}

