/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.csi;

import csi.v1.Csi;
import csi.v1.NodeGrpc;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.ozone.csi.CsiServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeService
extends NodeGrpc.NodeImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(NodeService.class);
    private final String mountCommand;
    private String s3Endpoint;

    public NodeService(CsiServer.CsiConfig configuration) {
        this.s3Endpoint = configuration.getS3gAddress();
        this.mountCommand = configuration.getMountCommand();
    }

    @Override
    public void nodePublishVolume(Csi.NodePublishVolumeRequest request, StreamObserver<Csi.NodePublishVolumeResponse> responseObserver) {
        try {
            Files.createDirectories(Paths.get(request.getTargetPath(), new String[0]), new FileAttribute[0]);
            String command = String.format(this.mountCommand, this.s3Endpoint, request.getVolumeId(), request.getTargetPath());
            LOG.info("Executing {}", (Object)command);
            this.executeCommand(command);
            responseObserver.onNext((Object)Csi.NodePublishVolumeResponse.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
    }

    private void executeCommand(String command) throws IOException, InterruptedException {
        Process exec = Runtime.getRuntime().exec(command);
        exec.waitFor(10L, TimeUnit.SECONDS);
        LOG.info("Command is executed with  stdout: {}, stderr: {}", (Object)IOUtils.toString((InputStream)exec.getInputStream(), (Charset)StandardCharsets.UTF_8), (Object)IOUtils.toString((InputStream)exec.getErrorStream(), (Charset)StandardCharsets.UTF_8));
        if (exec.exitValue() != 0) {
            throw new RuntimeException(String.format("Return code of the command %s was %d", command, exec.exitValue()));
        }
    }

    @Override
    public void nodeUnpublishVolume(Csi.NodeUnpublishVolumeRequest request, StreamObserver<Csi.NodeUnpublishVolumeResponse> responseObserver) {
        String umountCommand = String.format("fusermount -u %s", request.getTargetPath());
        LOG.info("Executing {}", (Object)umountCommand);
        try {
            this.executeCommand(umountCommand);
            responseObserver.onNext((Object)Csi.NodeUnpublishVolumeResponse.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
    }

    @Override
    public void nodeGetCapabilities(Csi.NodeGetCapabilitiesRequest request, StreamObserver<Csi.NodeGetCapabilitiesResponse> responseObserver) {
        Csi.NodeGetCapabilitiesResponse response = Csi.NodeGetCapabilitiesResponse.newBuilder().build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    @Override
    public void nodeGetInfo(Csi.NodeGetInfoRequest request, StreamObserver<Csi.NodeGetInfoResponse> responseObserver) {
        Csi.NodeGetInfoResponse response = null;
        try {
            response = Csi.NodeGetInfoResponse.newBuilder().setNodeId(InetAddress.getLocalHost().getHostName()).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        }
        catch (UnknownHostException e) {
            responseObserver.onError((Throwable)e);
        }
    }
}

