/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rocksdb.AbstractComparator;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.ComparatorOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class ComparatorBug {
    public static void main(String[] stringArray) {
        ColumnFamilyOptions columnFamilyOptions = new ColumnFamilyOptions();
        columnFamilyOptions.setComparator(new VersionedComparator(new ComparatorOptions()));
        byte[] byArray = RocksDB.DEFAULT_COLUMN_FAMILY;
        ColumnFamilyDescriptor columnFamilyDescriptor = new ColumnFamilyDescriptor(byArray, columnFamilyOptions);
        List<ColumnFamilyDescriptor> list = Collections.singletonList(columnFamilyDescriptor);
        ArrayList<ColumnFamilyHandle> arrayList = new ArrayList<ColumnFamilyHandle>(1);
        DBOptions dBOptions = new DBOptions();
        dBOptions.setCreateIfMissing(true);
        dBOptions.setCreateMissingColumnFamilies(true);
        try (RocksDB rocksDB = RocksDB.open(dBOptions, "test", list, arrayList);){
            ColumnFamilyHandle columnFamilyHandle = arrayList.get(0);
            rocksDB.put(columnFamilyHandle, "justanotherrandomkey".getBytes(), "value".getBytes());
            System.out.println(new String(rocksDB.get(columnFamilyHandle, "justanotherrandomkey".getBytes())));
        }
        catch (RocksDBException rocksDBException) {
            rocksDBException.printStackTrace();
        }
    }

    public static class VersionedComparator
    extends AbstractComparator {
        private final int versionSize = 8;

        protected VersionedComparator(ComparatorOptions comparatorOptions) {
            super(comparatorOptions);
        }

        @Override
        public String name() {
            return "test";
        }

        @Override
        public int compare(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            return this.compareToWithOffsetAndLength(byteBuffer, byteBuffer.remaining() - 8, 8, byteBuffer2, byteBuffer2.remaining() - 8, 8);
        }

        private int compareToWithOffsetAndLength(ByteBuffer byteBuffer, int n, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
            int n5 = Math.min(n2, n4);
            for (int i = 0; i < n5; ++i) {
                int n6;
                int n7 = byteBuffer.get(i + n) & 0xFF;
                if (n7 == (n6 = byteBuffer2.get(i + n3) & 0xFF)) continue;
                return n7 - n6;
            }
            return n2 - n4;
        }
    }
}

