/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;

public class ChecksumByteBufferImpl
implements ChecksumByteBuffer {
    private Checksum checksum;

    public ChecksumByteBufferImpl(Checksum impl) {
        this.checksum = impl;
    }

    @Override
    public void update(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            this.checksum.update(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.remaining());
        } else {
            byte[] b = new byte[buffer.remaining()];
            buffer.get(b);
            this.checksum.update(b, 0, b.length);
        }
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.checksum.update(b, off, len);
    }

    @Override
    public void update(int i) {
        this.checksum.update(i);
    }

    @Override
    public long getValue() {
        return this.checksum.getValue();
    }

    @Override
    public void reset() {
        this.checksum.reset();
    }
}

