/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.util.Preconditions;

public class ResourceSemaphore
extends Semaphore {
    private final int limit;
    private final AtomicBoolean reducePermits = new AtomicBoolean();
    private final AtomicBoolean isClosed = new AtomicBoolean();

    public ResourceSemaphore(int limit) {
        super(limit, true);
        Preconditions.assertTrue((limit > 0 ? 1 : 0) != 0, () -> "limit = " + limit + " <= 0");
        this.limit = limit;
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        this.assertRelease(permits);
        super.release(permits);
        this.assertAvailable();
    }

    private void assertRelease(int toRelease) {
        Preconditions.assertTrue((toRelease >= 0 ? 1 : 0) != 0, () -> "toRelease = " + toRelease + " < 0");
        int available = this.assertAvailable();
        int permits = Math.addExact(available, toRelease);
        Preconditions.assertTrue((permits <= this.limit ? 1 : 0) != 0, () -> "permits = " + permits + " > limit = " + this.limit);
    }

    private int assertAvailable() {
        int available = this.availablePermits();
        Preconditions.assertTrue((available >= 0 ? 1 : 0) != 0, () -> "available = " + available + " < 0");
        return available;
    }

    public int used() {
        return this.limit - this.availablePermits();
    }

    public void close() {
        if (this.reducePermits.compareAndSet(false, true)) {
            this.reducePermits(this.limit);
            this.isClosed.set(true);
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public String toString() {
        return (this.isClosed() ? "closed/" : this.availablePermits() + "/") + this.limit;
    }

    public static class Group {
        private final List<ResourceSemaphore> resources;

        public Group(int ... limits) {
            ArrayList<ResourceSemaphore> list = new ArrayList<ResourceSemaphore>(limits.length);
            for (int limit : limits) {
                list.add(new ResourceSemaphore(limit));
            }
            this.resources = Collections.unmodifiableList(list);
        }

        int resourceSize() {
            return this.resources.size();
        }

        protected ResourceSemaphore get(int i) {
            return this.resources.get(i);
        }

        boolean tryAcquire(int ... permits) {
            int i;
            Preconditions.assertTrue((permits.length == this.resources.size() ? 1 : 0) != 0, () -> "items.length = " + permits.length + " != resources.size() = " + this.resources.size());
            for (i = 0; i < permits.length && this.resources.get(i).tryAcquire(permits[i]); ++i) {
            }
            if (i == permits.length) {
                return true;
            }
            --i;
            while (i >= 0) {
                this.resources.get(i).release(permits[i]);
                --i;
            }
            return false;
        }

        public void acquire(int ... permits) throws InterruptedException {
            Preconditions.assertTrue((permits.length == this.resources.size() ? 1 : 0) != 0, () -> "items.length = " + permits.length + " != resources.size() = " + this.resources.size());
            for (int i = 0; i < permits.length; ++i) {
                this.resources.get(i).acquire(permits[i]);
            }
        }

        protected void release(int ... permits) {
            for (int i = this.resources.size() - 1; i >= 0; --i) {
                this.resources.get(i).release(permits[i]);
            }
        }

        public void close() {
            for (int i = this.resources.size() - 1; i >= 0; --i) {
                this.resources.get(i).close();
            }
        }

        public boolean isClosed() {
            return this.resources.get(this.resources.size() - 1).isClosed();
        }

        public String toString() {
            return this.resources + ",size=" + this.resources.size();
        }
    }
}

