/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.insight.BaseInsightSubCommand;
import org.apache.hadoop.ozone.insight.Component;
import org.apache.hadoop.ozone.insight.InsightPoint;
import org.apache.hadoop.ozone.insight.LoggerSource;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import picocli.CommandLine;

@CommandLine.Command(name="log", aliases={"logs"}, description={"Show log4j events related to the insight point"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class LogSubcommand
extends BaseInsightSubCommand
implements Callable<Void> {
    @CommandLine.Parameters(description={"Name of the insight point (use list to check the available options)"})
    private String insightName;
    @CommandLine.Option(names={"-v"}, description={"Enable verbose mode to show more information / detailed message"})
    private boolean verbose;
    @CommandLine.Option(names={"-f"}, description={"Define filters to scope the output (eg. -f datanode=_1234_datanode_id)"})
    private Map<String, String> filters;

    @Override
    public Void call() {
        OzoneConfiguration conf = this.getInsightCommand().createOzoneConfiguration();
        InsightPoint insight = this.getInsight(conf, this.insightName);
        List<LoggerSource> loggers = insight.getRelatedLoggers(this.verbose, this.filters);
        this.setLogLevels(conf, loggers, LoggerSource::getLevel);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.setLogLevels(conf, loggers, any -> LoggerSource.Level.INFO)));
        Set<Component> sources = loggers.stream().map(LoggerSource::getComponent).collect(Collectors.toSet());
        this.streamLog(conf, sources, loggers, (String logLine) -> insight.filterLog(this.filters, (String)logLine));
        return null;
    }

    private void streamLog(OzoneConfiguration conf, Set<Component> sources, List<LoggerSource> relatedLoggers, Predicate<String> filter) {
        ArrayList<Thread> loggers = new ArrayList<Thread>();
        for (Component sourceComponent : sources) {
            loggers.add(new Thread(() -> this.streamLog(conf, sourceComponent, relatedLoggers, filter)));
        }
        for (Thread thread : loggers) {
            thread.start();
        }
        for (Thread thread : loggers) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
        }
    }

    private void streamLog(OzoneConfiguration conf, Component logComponent, List<LoggerSource> loggers, Predicate<String> filter) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getHost(conf, logComponent) + "/logstream");
        try {
            HttpResponse execute = client.execute((HttpUriRequest)get);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(execute.getEntity().getContent(), StandardCharsets.UTF_8));){
                bufferedReader.lines().filter(line -> {
                    for (LoggerSource logger : loggers) {
                        if (!line.contains(logger.getLoggerName()) || !filter.test((String)line)) continue;
                        return true;
                    }
                    return false;
                }).map(this::processLogLine).map(l -> "[" + logComponent.prefix() + "] " + l).forEach(System.out::println);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String processLogLine(String line) {
        Pattern p = Pattern.compile("<json>(.*)</json>");
        Matcher m = p.matcher(line);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "\n" + m.group(1).replaceAll("\\\\n", "\n"));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private void setLogLevels(OzoneConfiguration conf, List<LoggerSource> loggers, Function<LoggerSource, LoggerSource.Level> toLevel) {
        for (LoggerSource logger : loggers) {
            this.setLogLevel(conf, logger.getLoggerName(), logger.getComponent(), toLevel.apply(logger));
        }
    }

    private void setLogLevel(OzoneConfiguration conf, String name, Component component, LoggerSource.Level level) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        String request = String.format("/logLevel?log=%s&level=%s", new Object[]{name, level});
        String hostName = this.getHost(conf, component);
        HttpGet get = new HttpGet(hostName + request);
        try {
            HttpResponse execute = client.execute((HttpUriRequest)get);
            if (execute.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Can't set the log level: " + hostName + " -> HTTP " + execute.getStatusLine().getStatusCode());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

