/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.s3.SignatureProcessor;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;

public class EndpointBase {
    @Inject
    private OzoneClient client;
    @Inject
    private SignatureProcessor signatureProcessor;

    protected OzoneBucket getBucket(OzoneVolume volume, String bucketName) throws OS3Exception, IOException {
        OzoneBucket bucket;
        try {
            bucket = volume.getBucket(bucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.KEY_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
            }
            throw ex;
        }
        return bucket;
    }

    protected OzoneBucket getBucket(String bucketName) throws OS3Exception, IOException {
        OzoneBucket bucket;
        try {
            bucket = this.client.getObjectStore().getS3Bucket(bucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND || ex.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName);
            }
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName);
            }
            throw ex;
        }
        return bucket;
    }

    protected OzoneVolume getVolume() throws IOException {
        String s3VolumeName = HddsClientUtils.getS3VolumeName((ConfigurationSource)this.client.getConfiguration());
        return this.client.getObjectStore().getVolume(s3VolumeName);
    }

    protected String createS3Bucket(String bucketName) throws IOException, OS3Exception {
        block3: {
            try {
                this.client.getObjectStore().createS3Bucket(bucketName);
            }
            catch (OMException ex) {
                if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                    throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName);
                }
                if (ex.getResult() == OMException.ResultCodes.BUCKET_ALREADY_EXISTS) break block3;
                throw ex;
            }
        }
        return "/" + bucketName;
    }

    public void deleteS3Bucket(String s3BucketName) throws IOException, OS3Exception {
        try {
            this.client.getObjectStore().deleteS3Bucket(s3BucketName);
        }
        catch (OMException ex) {
            if (ex.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, s3BucketName);
            }
            throw ex;
        }
    }

    public Iterator<? extends OzoneBucket> listS3Buckets(String prefix) throws IOException, OS3Exception {
        return this.iterateBuckets(volume -> volume.listBuckets(prefix));
    }

    public Iterator<? extends OzoneBucket> listS3Buckets(String prefix, String previousBucket) throws IOException, OS3Exception {
        return this.iterateBuckets(volume -> volume.listBuckets(prefix, previousBucket));
    }

    private Iterator<? extends OzoneBucket> iterateBuckets(Function<OzoneVolume, Iterator<? extends OzoneBucket>> query) throws IOException, OS3Exception {
        try {
            return query.apply(this.getVolume());
        }
        catch (OMException e) {
            if (e.getResult() == OMException.ResultCodes.VOLUME_NOT_FOUND) {
                return Collections.emptyIterator();
            }
            if (e.getResult() == OMException.ResultCodes.PERMISSION_DENIED) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, "listBuckets");
            }
            throw e;
        }
    }

    public SignatureProcessor getSignatureProcessor() {
        return this.signatureProcessor;
    }

    @VisibleForTesting
    public void setSignatureProcessor(SignatureProcessor signatureProcessor) {
        this.signatureProcessor = signatureProcessor;
    }

    @VisibleForTesting
    public void setClient(OzoneClient ozoneClient) {
        this.client = ozoneClient;
    }
}

