/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.s3.SignatureProcessor;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class OzoneClientProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneClientProducer.class);
    private OzoneClient client;
    @Inject
    private SignatureProcessor signatureParser;
    @Inject
    private OzoneConfiguration ozoneConfiguration;
    @Inject
    private Text omService;
    @Inject
    private String omServiceID;

    @Produces
    public OzoneClient createClient() throws OS3Exception, IOException {
        this.client = this.getClient(this.ozoneConfiguration);
        return this.client;
    }

    @PreDestroy
    public void destroy() throws IOException {
        this.client.close();
    }

    private OzoneClient getClient(OzoneConfiguration config) throws OS3Exception {
        OzoneClient ozoneClient = null;
        try {
            if (this.signatureParser.getException() != null) {
                throw this.signatureParser.getException();
            }
            String awsAccessId = this.signatureParser.getAwsAccessId();
            this.validateAccessId(awsAccessId);
            UserGroupInformation remoteUser = UserGroupInformation.createRemoteUser((String)awsAccessId);
            if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)config)) {
                LOG.debug("Creating s3 auth info for client.");
                try {
                    OzoneTokenIdentifier identifier = new OzoneTokenIdentifier();
                    identifier.setTokenType(OzoneManagerProtocolProtos.OMTokenProto.Type.S3AUTHINFO);
                    identifier.setStrToSign(this.signatureParser.getStringToSign());
                    identifier.setSignature(this.signatureParser.getSignature());
                    identifier.setAwsAccessId(awsAccessId);
                    identifier.setOwner(new Text(awsAccessId));
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Adding token for service:{}", (Object)this.omService);
                    }
                    Token token = new Token(identifier.getBytes(), identifier.getSignature().getBytes(StandardCharsets.UTF_8), identifier.getKind(), this.omService);
                    remoteUser.addToken(token);
                }
                catch (URISyntaxException | OS3Exception ex) {
                    throw S3ErrorTable.S3_AUTHINFO_CREATION_ERROR;
                }
            }
            ozoneClient = (OzoneClient)remoteUser.doAs(() -> {
                if (this.omServiceID == null) {
                    return OzoneClientFactory.getRpcClient((ConfigurationSource)this.ozoneConfiguration);
                }
                return OzoneClientFactory.getRpcClient((String)this.omServiceID, (ConfigurationSource)this.ozoneConfiguration);
            });
        }
        catch (OS3Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error during Client Creation: ", (Throwable)ex);
            }
            throw ex;
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error during Client Creation: ", t);
            }
            throw S3ErrorTable.INTERNAL_ERROR;
        }
        return ozoneClient;
    }

    private void validateAccessId(String awsAccessId) throws Exception {
        if (awsAccessId == null || awsAccessId.equals("")) {
            LOG.error("Malformed s3 header. awsAccessID: ", (Object)awsAccessId);
            throw S3ErrorTable.MALFORMED_HEADER;
        }
    }

    public void setOzoneConfiguration(OzoneConfiguration config) {
        this.ozoneConfiguration = config;
    }

    @VisibleForTesting
    public void setSignatureParser(SignatureProcessor signatureParser) {
        this.signatureParser = signatureParser;
    }
}

