/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class CloseContainerCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto> {
    private final PipelineID pipelineID;
    private boolean force;

    public CloseContainerCommand(long containerID, PipelineID pipelineID) {
        this(containerID, pipelineID, false);
    }

    public CloseContainerCommand(long containerID, PipelineID pipelineID, boolean force) {
        super(containerID);
        this.pipelineID = pipelineID;
        this.force = force;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto getProto() {
        return StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto.newBuilder().setContainerID(this.getId()).setCmdId(this.getId()).setPipelineID(this.pipelineID.getProtobuf()).setForce(this.force).build();
    }

    public static CloseContainerCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto closeContainerProto) {
        Preconditions.checkNotNull((Object)closeContainerProto);
        return new CloseContainerCommand(closeContainerProto.getCmdId(), PipelineID.getFromProtobuf((HddsProtos.PipelineID)closeContainerProto.getPipelineID()), closeContainerProto.getForce());
    }

    public long getContainerID() {
        return this.getId();
    }

    public PipelineID getPipelineID() {
        return this.pipelineID;
    }
}

