/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.ozone.container.replication.ContainerDownloader;
import org.apache.hadoop.ozone.container.replication.GrpcReplicationClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleContainerDownloader
implements ContainerDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleContainerDownloader.class);
    private final Path workingDirectory;
    private final SecurityConfig securityConfig;
    private final CertificateClient certClient;

    public SimpleContainerDownloader(ConfigurationSource conf, CertificateClient certClient) {
        String workDirString = conf.get("hdds.datanode.replication.work.dir");
        this.workingDirectory = workDirString == null ? Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("container-copy") : Paths.get(workDirString, new String[0]);
        this.securityConfig = new SecurityConfig(conf);
        this.certClient = certClient;
    }

    @Override
    public CompletableFuture<Path> getContainerDataFromReplicas(long containerId, List<DatanodeDetails> sourceDatanodes) {
        CompletionStage<Path> result = null;
        List<DatanodeDetails> shuffledDatanodes = this.shuffleDatanodes(sourceDatanodes);
        for (DatanodeDetails datanode : shuffledDatanodes) {
            try {
                if (result == null) {
                    result = this.downloadContainer(containerId, datanode);
                    continue;
                }
                result = result.exceptionally(t -> {
                    LOG.error("Error on replicating container: " + containerId, t);
                    try {
                        return this.downloadContainer(containerId, datanode).join();
                    }
                    catch (Exception e) {
                        LOG.error("Error on replicating container: " + containerId, (Throwable)e);
                        return null;
                    }
                });
            }
            catch (Exception ex) {
                LOG.error(String.format("Container %s download from datanode %s was unsuccessful. Trying the next datanode", containerId, datanode), (Throwable)ex);
            }
        }
        return result;
    }

    protected List<DatanodeDetails> shuffleDatanodes(List<DatanodeDetails> sourceDatanodes) {
        ArrayList<DatanodeDetails> shuffledDatanodes = new ArrayList<DatanodeDetails>(sourceDatanodes);
        Collections.shuffle(shuffledDatanodes);
        return shuffledDatanodes;
    }

    @VisibleForTesting
    protected CompletableFuture<Path> downloadContainer(long containerId, DatanodeDetails datanode) throws IOException {
        GrpcReplicationClient grpcReplicationClient = new GrpcReplicationClient(datanode.getIpAddress(), datanode.getPort(DatanodeDetails.Port.Name.REPLICATION).getValue(), this.workingDirectory, this.securityConfig, this.certClient);
        CompletionStage result = grpcReplicationClient.download(containerId).thenApply(r -> {
            try {
                grpcReplicationClient.close();
            }
            catch (Exception e) {
                LOG.error("Couldn't close Grpc replication client", (Throwable)e);
            }
            return r;
        });
        return result;
    }

    @Override
    public void close() {
    }
}

