/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationSupervisor {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSupervisor.class);
    private final ContainerSet containerSet;
    private final ContainerReplicator replicator;
    private final ExecutorService executor;
    private final AtomicLong requestCounter = new AtomicLong();
    private final AtomicLong successCounter = new AtomicLong();
    private final AtomicLong failureCounter = new AtomicLong();
    private final ConcurrentHashMap.KeySetView<Object, Boolean> containersInFlight;

    @VisibleForTesting
    ReplicationSupervisor(ContainerSet containerSet, ContainerReplicator replicator, ExecutorService executor) {
        this.containerSet = containerSet;
        this.replicator = replicator;
        this.containersInFlight = ConcurrentHashMap.newKeySet();
        this.executor = executor;
    }

    public ReplicationSupervisor(ContainerSet containerSet, ContainerReplicator replicator, int poolSize) {
        this(containerSet, replicator, new ThreadPoolExecutor(poolSize, poolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ContainerReplicationThread-%d").build()));
    }

    public void addTask(ReplicationTask task) {
        if (this.containersInFlight.add((Object)task.getContainerId())) {
            this.executor.execute(new TaskRunner(task));
        }
    }

    @VisibleForTesting
    public void shutdownAfterFinish() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(1L, TimeUnit.DAYS);
    }

    public void stop() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    @VisibleForTesting
    int getInFlightReplications() {
        return this.containersInFlight.size();
    }

    public long getReplicationRequestCount() {
        return this.requestCounter.get();
    }

    public long getReplicationSuccessCount() {
        return this.successCounter.get();
    }

    public long getReplicationFailureCount() {
        return this.failureCounter.get();
    }

    public final class TaskRunner
    implements Runnable {
        private final ReplicationTask task;

        public TaskRunner(ReplicationTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            Long containerId = this.task.getContainerId();
            try {
                ReplicationSupervisor.this.requestCounter.incrementAndGet();
                if (ReplicationSupervisor.this.containerSet.getContainer(this.task.getContainerId()) != null) {
                    LOG.debug("Container {} has already been downloaded.", (Object)containerId);
                    return;
                }
                this.task.setStatus(ReplicationTask.Status.DOWNLOADING);
                ReplicationSupervisor.this.replicator.replicate(this.task);
                if (this.task.getStatus() == ReplicationTask.Status.FAILED) {
                    LOG.error("Container {} can't be downloaded from any of the datanodes.", (Object)containerId);
                    ReplicationSupervisor.this.failureCounter.incrementAndGet();
                } else if (this.task.getStatus() == ReplicationTask.Status.DONE) {
                    LOG.info("Container {} is replicated.", (Object)containerId);
                    ReplicationSupervisor.this.successCounter.incrementAndGet();
                }
            }
            catch (Exception e) {
                this.task.setStatus(ReplicationTask.Status.FAILED);
                LOG.error("Encountered error while replicating container {}.", (Object)containerId, (Object)e);
                ReplicationSupervisor.this.failureCounter.incrementAndGet();
            }
            finally {
                ReplicationSupervisor.this.containersInFlight.remove(containerId);
            }
        }
    }
}

