/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import com.google.common.primitives.Longs;
import java.io.IOException;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaOneKeyCodec
implements Codec<String> {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaOneKeyCodec.class);

    public byte[] toPersistedFormat(String stringObject) {
        try {
            long longObject = Long.parseLong(stringObject);
            return Longs.toByteArray((long)longObject);
        }
        catch (NumberFormatException ex) {
            return StringUtils.string2Bytes((String)stringObject);
        }
    }

    public String fromPersistedFormat(byte[] rawData) throws IOException {
        String prefixedBlockRegex = "^#[a-zA-Z]+#[0-9]+$";
        String metadataRegex = "^#[a-zA-Z]$";
        String stringData = StringUtils.bytes2String((byte[])rawData);
        if (stringData.matches("^#[a-zA-Z]+#[0-9]+$") || stringData.matches("^#[a-zA-Z]$")) {
            LOG.trace("Byte array {} matched the format for a string key. It will be parsed as the string {}", (Object)rawData, (Object)stringData);
            return stringData;
        }
        if (rawData.length == 8) {
            long longData = Longs.fromByteArray((byte[])rawData);
            LOG.trace("Byte array {} did not match the format for a string key and has {} bytes. It will be parsed as the long {}", new Object[]{rawData, 8, longData});
            return Long.toString(longData);
        }
        LOG.trace("Byte array {} did not match the format for a string key and does not have {} bytes. It will be parsed as the string {}", new Object[]{rawData, 8, stringData});
        return stringData;
    }

    public String copyObject(String object) {
        return object;
    }
}

