/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerDispatcher;
import org.apache.hadoop.ozone.container.keyvalue.impl.ChunkManagerDummyImpl;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.BlockManager;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerScrubberConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkManagerFactory.class);

    private ChunkManagerFactory() {
    }

    public static ChunkManager createChunkManager(ConfigurationSource conf, BlockManager manager) {
        ContainerScrubberConfiguration scrubber;
        boolean sync = conf.getBoolean("dfs.container.chunk.write.sync", false);
        boolean persist = conf.getBoolean("hdds.container.chunk.persistdata", true);
        if (!persist && (scrubber = (ContainerScrubberConfiguration)conf.getObject(ContainerScrubberConfiguration.class)).isEnabled()) {
            LOG.warn("Failed to set hdds.container.chunk.persistdata to false. Please set hdds.container.scrub.enabled also to false to enable non-persistent containers.");
            persist = true;
        }
        if (!persist) {
            LOG.warn("hdds.container.chunk.persistdata is set to false. This should be used only for testing. All user data will be discarded.");
            return new ChunkManagerDummyImpl();
        }
        return new ChunkManagerDispatcher(sync, manager);
    }
}

