/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.utils.ContainerCache;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaOneImpl;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaTwoImpl;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static DatanodeStore getUncachedDatanodeStore(long containerID, String containerDBPath, String schemaVersion, ConfigurationSource conf, boolean readOnly) throws IOException {
        AbstractDatanodeStore store;
        if (schemaVersion.equals("1")) {
            store = new DatanodeStoreSchemaOneImpl(conf, containerID, containerDBPath, readOnly);
        } else if (schemaVersion.equals("2")) {
            store = new DatanodeStoreSchemaTwoImpl(conf, containerID, containerDBPath, readOnly);
        } else {
            throw new IllegalArgumentException("Unrecognized database schema version: " + schemaVersion);
        }
        return store;
    }

    public static DatanodeStore getUncachedDatanodeStore(KeyValueContainerData containerData, ConfigurationSource conf, boolean readOnly) throws IOException {
        return BlockUtils.getUncachedDatanodeStore(containerData.getContainerID(), containerData.getDbFile().getAbsolutePath(), containerData.getSchemaVersion(), conf, readOnly);
    }

    public static ReferenceCountedDB getDB(KeyValueContainerData containerData, ConfigurationSource conf) throws StorageContainerException {
        Preconditions.checkNotNull((Object)containerData);
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        Preconditions.checkNotNull((Object)containerData.getDbFile());
        try {
            return cache.getDB(containerData.getContainerID(), containerData.getContainerDBType(), containerData.getDbFile().getAbsolutePath(), containerData.getSchemaVersion(), conf);
        }
        catch (IOException ex) {
            String message = String.format("Error opening DB. Container:%s ContainerPath:%s", containerData.getContainerID(), containerData.getDbFile().getPath());
            throw new StorageContainerException(message, ContainerProtos.Result.UNABLE_TO_READ_METADATA_DB);
        }
    }

    public static void removeDB(KeyValueContainerData container, ConfigurationSource conf) {
        Preconditions.checkNotNull((Object)container);
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        cache.removeDB(container.getDbFile().getAbsolutePath());
    }

    public static void shutdownCache(ContainerCache cache) {
        cache.shutdownCache();
    }

    public static void addDB(ReferenceCountedDB db, String containerDBPath, ConfigurationSource conf) {
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        cache.addDB(containerDBPath, db);
    }

    public static BlockData getBlockData(byte[] bytes) throws IOException {
        try {
            ContainerProtos.BlockData blockData = ContainerProtos.BlockData.parseFrom((byte[])bytes);
            return BlockData.getFromProtoBuf((ContainerProtos.BlockData)blockData);
        }
        catch (IOException e) {
            throw new StorageContainerException("Failed to parse block data from the bytes array.", ContainerProtos.Result.NO_SUCH_BLOCK);
        }
    }
}

