/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.yaml.snakeyaml.nodes.Tag;

public class KeyValueContainerData
extends ContainerData {
    public static final Tag KEYVALUE_YAML_TAG = new Tag("KeyValueContainerData");
    private static final List<String> KV_YAML_FIELDS = Lists.newArrayList();
    private String metadataPath;
    private String containerDBType = "RocksDB";
    private File dbFile = null;
    private String schemaVersion;
    private final AtomicLong numPendingDeletionBlocks;
    private long deleteTransactionId;
    private long blockCommitSequenceId;

    public KeyValueContainerData(long id, ChunkLayOutVersion layOutVersion, long size, String originPipelineId, String originNodeId) {
        super(ContainerProtos.ContainerType.KeyValueContainer, id, layOutVersion, size, originPipelineId, originNodeId);
        this.numPendingDeletionBlocks = new AtomicLong(0L);
        this.deleteTransactionId = 0L;
    }

    public KeyValueContainerData(ContainerData source) {
        super(source);
        Preconditions.checkArgument((source.getContainerType() == ContainerProtos.ContainerType.KeyValueContainer ? 1 : 0) != 0);
        this.numPendingDeletionBlocks = new AtomicLong(0L);
        this.deleteTransactionId = 0L;
    }

    public void setSchemaVersion(String version) {
        this.schemaVersion = version;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setDbFile(File containerDbFile) {
        this.dbFile = containerDbFile;
    }

    public File getDbFile() {
        return this.dbFile;
    }

    public String getMetadataPath() {
        return this.metadataPath;
    }

    public void setMetadataPath(String path) {
        this.metadataPath = path;
    }

    @Override
    public String getContainerPath() {
        return new File(this.metadataPath).getParent();
    }

    @Override
    public long getBlockCommitSequenceId() {
        return this.blockCommitSequenceId;
    }

    public void updateBlockCommitSequenceId(long id) {
        this.blockCommitSequenceId = id;
    }

    public String getContainerDBType() {
        return this.containerDBType;
    }

    public void setContainerDBType(String containerDBType) {
        this.containerDBType = containerDBType;
    }

    public void incrPendingDeletionBlocks(long numBlocks) {
        this.numPendingDeletionBlocks.addAndGet(numBlocks);
    }

    public void decrPendingDeletionBlocks(long numBlocks) {
        this.numPendingDeletionBlocks.addAndGet(-1L * numBlocks);
    }

    public long getNumPendingDeletionBlocks() {
        return this.numPendingDeletionBlocks.get();
    }

    public void updateDeleteTransactionId(long transactionId) {
        this.deleteTransactionId = Math.max(transactionId, this.deleteTransactionId);
    }

    public long getDeleteTransactionId() {
        return this.deleteTransactionId;
    }

    @Override
    public ContainerProtos.ContainerDataProto getProtoBufMessage() {
        ContainerProtos.ContainerDataProto.Builder builder = ContainerProtos.ContainerDataProto.newBuilder();
        builder.setContainerID(this.getContainerID());
        builder.setContainerPath(this.getContainerPath());
        builder.setState(this.getState());
        for (Map.Entry<String, String> entry : this.getMetadata().entrySet()) {
            ContainerProtos.KeyValue.Builder keyValBuilder = ContainerProtos.KeyValue.newBuilder();
            builder.addMetadata(keyValBuilder.setKey(entry.getKey()).setValue(entry.getValue()).build());
        }
        if (this.getBytesUsed() >= 0L) {
            builder.setBytesUsed(this.getBytesUsed());
        }
        if (this.getContainerType() != null) {
            builder.setContainerType(ContainerProtos.ContainerType.KeyValueContainer);
        }
        return builder.build();
    }

    public static List<String> getYamlFields() {
        return Collections.unmodifiableList(KV_YAML_FIELDS);
    }

    public void updateAndCommitDBCounters(ReferenceCountedDB db, BatchOperation batchOperation, int deletedBlockCount) throws IOException {
        Table<String, Long> metadataTable = db.getStore().getMetadataTable();
        metadataTable.putWithBatch(batchOperation, (Object)"#BYTESUSED", (Object)this.getBytesUsed());
        metadataTable.putWithBatch(batchOperation, (Object)"#BLOCKCOUNT", (Object)(this.getKeyCount() - (long)deletedBlockCount));
        metadataTable.putWithBatch(batchOperation, (Object)"#PENDINGDELETEBLOCKCOUNT", (Object)(this.getNumPendingDeletionBlocks() - (long)deletedBlockCount));
        db.getStore().getBatchHandler().commitBatchOperation(batchOperation);
    }

    static {
        KV_YAML_FIELDS.addAll(YAML_FIELDS);
        KV_YAML_FIELDS.add("metadataPath");
        KV_YAML_FIELDS.add("chunksPath");
        KV_YAML_FIELDS.add("containerDBType");
        KV_YAML_FIELDS.add("schemaVersion");
    }
}

