/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

public class VolumeIOStats {
    private String metricsSourceName = VolumeIOStats.class.getSimpleName();
    @Metric
    private MutableCounterLong readBytes;
    @Metric
    private MutableCounterLong readOpCount;
    @Metric
    private MutableCounterLong writeBytes;
    @Metric
    private MutableCounterLong writeOpCount;
    @Metric
    private MutableCounterLong readTime;
    @Metric
    private MutableCounterLong writeTime;

    @Deprecated
    public VolumeIOStats() {
        this.init();
    }

    public VolumeIOStats(String identifier) {
        this.metricsSourceName = this.metricsSourceName + '-' + identifier;
        this.init();
    }

    public void init() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.register(this.metricsSourceName, "Volume I/O Statistics", (Object)this);
    }

    public void unregister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(this.metricsSourceName);
    }

    public String getMetricsSourceName() {
        return this.metricsSourceName;
    }

    public void incReadBytes(long bytesRead) {
        this.readBytes.incr(bytesRead);
    }

    public void incReadOpCount() {
        this.readOpCount.incr();
    }

    public void incWriteBytes(long bytesWritten) {
        this.writeBytes.incr(bytesWritten);
    }

    public void incWriteOpCount() {
        this.writeOpCount.incr();
    }

    public void incReadTime(long time) {
        this.readTime.incr(time);
    }

    public void incWriteTime(long time) {
        this.writeTime.incr(time);
    }

    public long getReadBytes() {
        return this.readBytes.value();
    }

    public long getWriteBytes() {
        return this.writeBytes.value();
    }

    public long getReadOpCount() {
        return this.readOpCount.value();
    }

    public long getWriteOpCount() {
        return this.writeOpCount.value();
    }

    public long getReadTime() {
        return this.readTime.value();
    }

    public long getWriteTime() {
        return this.writeTime.value();
    }
}

