/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.GeneratedMessage;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.util.GlobalTracer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.DatanodeRatisServerConfig;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.ratis.ContainerCommandRequestMessage;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.StorageLocationReport;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.ContainerStateMachine;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.RatisServerConfiguration;
import org.apache.hadoop.ozone.container.common.volume.MutableVolumeSet;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XceiverServerRatis
implements XceiverServerSpi {
    private static final Logger LOG = LoggerFactory.getLogger(XceiverServerRatis.class);
    private static final AtomicLong CALL_ID_COUNTER = new AtomicLong();
    private static final List<Integer> DEFAULT_PRIORITY_LIST = new ArrayList<Integer>(Collections.nCopies(3, 0));
    private int serverPort;
    private int adminPort;
    private int clientPort;
    private final RaftServer server;
    private final List<ThreadPoolExecutor> chunkExecutors;
    private final ContainerDispatcher dispatcher;
    private final ContainerController containerController;
    private ClientId clientId = ClientId.randomId();
    private final StateContext context;
    private long nodeFailureTimeoutMs;
    private boolean isStarted = false;
    private DatanodeDetails datanodeDetails;
    private final ConfigurationSource conf;
    private final Set<RaftGroupId> raftGids = new HashSet<RaftGroupId>();
    private final RaftPeerId raftPeerId;
    private Map<RaftGroupId, Boolean> groupLeaderMap = new ConcurrentHashMap<RaftGroupId, Boolean>();
    private long requestTimeout;
    private boolean shouldDeleteRatisLogDirectory;
    private EnumMap<StorageType, List<String>> ratisVolumeMap;

    private static long nextCallId() {
        return CALL_ID_COUNTER.getAndIncrement() & Long.MAX_VALUE;
    }

    private XceiverServerRatis(DatanodeDetails dd, ContainerDispatcher dispatcher, ContainerController containerController, StateContext context, ConfigurationSource conf, Parameters parameters) throws IOException {
        this.conf = conf;
        Objects.requireNonNull(dd, "id == null");
        this.datanodeDetails = dd;
        this.assignPorts();
        RaftProperties serverProperties = this.newRaftProperties();
        this.context = context;
        this.dispatcher = dispatcher;
        this.containerController = containerController;
        this.raftPeerId = RatisHelper.toRaftPeerId((DatanodeDetails)dd);
        this.chunkExecutors = XceiverServerRatis.createChunkExecutors(conf);
        this.nodeFailureTimeoutMs = ((DatanodeRatisServerConfig)conf.getObject(DatanodeRatisServerConfig.class)).getFollowerSlownessTimeout();
        this.shouldDeleteRatisLogDirectory = ((DatanodeRatisServerConfig)conf.getObject(DatanodeRatisServerConfig.class)).shouldDeleteRatisLogDirectory();
        RaftServer.Builder builder = RaftServer.newBuilder().setServerId(this.raftPeerId).setProperties(serverProperties).setStateMachineRegistry(this::getStateMachine).setParameters(parameters);
        this.server = builder.build();
        this.requestTimeout = conf.getTimeDuration("hdds.datanode.ratis.server.request.timeout", "2m", TimeUnit.MILLISECONDS);
        this.initializeRatisVolumeMap();
    }

    private void assignPorts() {
        this.clientPort = this.determinePort("dfs.container.ratis.ipc", 9858);
        if (this.datanodeDetails.getInitialVersion() >= 1) {
            this.adminPort = this.determinePort("dfs.container.ratis.admin.port", 9857);
            this.serverPort = this.determinePort("dfs.container.ratis.server.port", 9856);
        } else {
            this.adminPort = this.clientPort;
            this.serverPort = this.clientPort;
        }
    }

    private int determinePort(String key, int defaultValue) {
        boolean randomPort = this.conf.getBoolean("dfs.container.ratis.ipc.random.port", false);
        return randomPort ? 0 : this.conf.getInt(key, defaultValue);
    }

    private ContainerStateMachine getStateMachine(RaftGroupId gid) {
        return new ContainerStateMachine(gid, this.dispatcher, this.containerController, this.chunkExecutors, this, this.conf);
    }

    private RaftProperties newRaftProperties() {
        RaftProperties properties = new RaftProperties();
        RpcType rpc = this.setRpcType(properties);
        this.setRaftSegmentAndWriteBufferSize(properties);
        int raftSegmentPreallocatedSize = this.setRaftSegmentPreallocatedSize(properties);
        RaftServerConfigKeys.Log.StateMachineData.setSync((RaftProperties)properties, (boolean)true);
        TimeUnit timeUnit = OzoneConfigKeys.DFS_CONTAINER_RATIS_STATEMACHINEDATA_SYNC_TIMEOUT_DEFAULT.getUnit();
        long duration = this.conf.getTimeDuration("dfs.container.ratis.statemachinedata.sync.timeout", OzoneConfigKeys.DFS_CONTAINER_RATIS_STATEMACHINEDATA_SYNC_TIMEOUT_DEFAULT.getDuration(), timeUnit);
        TimeDuration dataSyncTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        RaftServerConfigKeys.Log.StateMachineData.setSyncTimeout((RaftProperties)properties, (TimeDuration)dataSyncTimeout);
        RaftServerConfigKeys.Log.StateMachineData.setSyncTimeoutRetry((RaftProperties)properties, (int)((int)this.nodeFailureTimeoutMs / dataSyncTimeout.toIntExact(TimeUnit.MILLISECONDS)));
        this.setTimeoutForRetryCache(properties);
        this.setRatisLeaderElectionTimeout(properties);
        RaftServerConfigKeys.Log.setSegmentCacheNumMax((RaftProperties)properties, (int)2);
        RaftServerConfigKeys.LeaderElection.setPreVote((RaftProperties)properties, (boolean)false);
        Collection storageDirPaths = HddsServerUtil.getOzoneDatanodeRatisDirectory((ConfigurationSource)this.conf);
        ArrayList storageDirs = new ArrayList(storageDirPaths.size());
        storageDirPaths.stream().forEach(d -> storageDirs.add(new File((String)d)));
        RaftServerConfigKeys.setStorageDir((RaftProperties)properties, storageDirs);
        GrpcConfigKeys.setMessageSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)(0x2000000 + raftSegmentPreallocatedSize)));
        if (rpc == SupportedRpcType.GRPC) {
            GrpcConfigKeys.Admin.setPort((RaftProperties)properties, (int)this.adminPort);
            GrpcConfigKeys.Client.setPort((RaftProperties)properties, (int)this.clientPort);
            GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)this.serverPort);
        } else if (rpc == SupportedRpcType.NETTY) {
            NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)this.serverPort);
        }
        long snapshotThreshold = this.conf.getLong("dfs.ratis.snapshot.threshold", 100000L);
        RaftServerConfigKeys.Snapshot.setAutoTriggerEnabled((RaftProperties)properties, (boolean)true);
        RaftServerConfigKeys.Snapshot.setAutoTriggerThreshold((RaftProperties)properties, (long)snapshotThreshold);
        this.setPendingRequestsLimits(properties);
        int logQueueNumElements = this.conf.getInt("dfs.container.ratis.log.queue.num-elements", 1024);
        int logQueueByteLimit = (int)this.conf.getStorageSize("dfs.container.ratis.log.queue.byte-limit", "4GB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.setQueueElementLimit((RaftProperties)properties, (int)logQueueNumElements);
        RaftServerConfigKeys.Log.setQueueByteLimit((RaftProperties)properties, (int)logQueueByteLimit);
        int numSyncRetries = this.conf.getInt("dfs.container.ratis.statemachinedata.sync.retries", -1);
        RaftServerConfigKeys.Log.StateMachineData.setSyncTimeoutRetry((RaftProperties)properties, (int)numSyncRetries);
        RaftServerConfigKeys.Log.StateMachineData.setCachingEnabled((RaftProperties)properties, (boolean)true);
        RaftServerConfigKeys.Log.Appender.setInstallSnapshotEnabled((RaftProperties)properties, (boolean)false);
        int purgeGap = this.conf.getInt("dfs.container.ratis.log.purge.gap", 1000000);
        RaftServerConfigKeys.Log.setPurgeGap((RaftProperties)properties, (int)purgeGap);
        RatisServerConfiguration ratisServerConfiguration = (RatisServerConfiguration)this.conf.getObject(RatisServerConfiguration.class);
        int numSnapshotsRetained = ratisServerConfiguration.getNumSnapshotsRetained();
        RaftServerConfigKeys.Snapshot.setRetentionFileNum((RaftProperties)properties, (int)numSnapshotsRetained);
        RatisHelper.createRaftServerProperties((ConfigurationSource)this.conf, (RaftProperties)properties);
        return properties;
    }

    private void setRatisLeaderElectionTimeout(RaftProperties properties) {
        TimeUnit leaderElectionMinTimeoutUnit = OzoneConfigKeys.DFS_RATIS_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getUnit();
        long duration = this.conf.getTimeDuration("dfs.ratis.leader.election.minimum.timeout.duration", OzoneConfigKeys.DFS_RATIS_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getDuration(), leaderElectionMinTimeoutUnit);
        TimeDuration leaderElectionMinTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)leaderElectionMinTimeoutUnit);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)leaderElectionMinTimeout);
        long leaderElectionMaxTimeout = leaderElectionMinTimeout.toLong(TimeUnit.MILLISECONDS) + 200L;
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)leaderElectionMaxTimeout, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    private void setTimeoutForRetryCache(RaftProperties properties) {
        TimeUnit timeUnit = OzoneConfigKeys.DFS_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DURATION_DEFAULT.getUnit();
        long duration = this.conf.getTimeDuration("dfs.ratis.server.retry-cache.timeout.duration", OzoneConfigKeys.DFS_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DURATION_DEFAULT.getDuration(), timeUnit);
        TimeDuration retryCacheTimeout = TimeDuration.valueOf((long)duration, (TimeUnit)timeUnit);
        RaftServerConfigKeys.RetryCache.setExpiryTime((RaftProperties)properties, (TimeDuration)retryCacheTimeout);
    }

    private int setRaftSegmentPreallocatedSize(RaftProperties properties) {
        int raftSegmentPreallocatedSize = (int)this.conf.getStorageSize("dfs.container.ratis.segment.preallocated.size", "16KB", StorageUnit.BYTES);
        int logAppenderQueueNumElements = this.conf.getInt("dfs.container.ratis.log.appender.queue.num-elements", 1);
        int logAppenderQueueByteLimit = (int)this.conf.getStorageSize("dfs.container.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)properties, (int)logAppenderQueueNumElements);
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentPreallocatedSize));
        return raftSegmentPreallocatedSize;
    }

    private void setRaftSegmentAndWriteBufferSize(RaftProperties properties) {
        int raftSegmentSize = (int)this.conf.getStorageSize("dfs.container.ratis.segment.size", "1MB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentSize));
        RaftServerConfigKeys.Log.setWriteBufferSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentSize));
    }

    private RpcType setRpcType(RaftProperties properties) {
        String rpcType = this.conf.get("dfs.container.ratis.rpc.type", "GRPC");
        SupportedRpcType rpc = SupportedRpcType.valueOfIgnoreCase((String)rpcType);
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpc);
        return rpc;
    }

    private void setPendingRequestsLimits(RaftProperties properties) {
        int pendingRequestsByteLimit = (int)this.conf.getStorageSize("dfs.container.ratis.leader.pending.bytes.limit", "1GB", StorageUnit.BYTES);
        RaftServerConfigKeys.Write.setByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)pendingRequestsByteLimit));
    }

    public static XceiverServerRatis newXceiverServerRatis(DatanodeDetails datanodeDetails, ConfigurationSource ozoneConf, ContainerDispatcher dispatcher, ContainerController containerController, CertificateClient caClient, StateContext context) throws IOException {
        Parameters parameters = XceiverServerRatis.createTlsParameters(new SecurityConfig(ozoneConf), caClient);
        return new XceiverServerRatis(datanodeDetails, dispatcher, containerController, context, ozoneConf, parameters);
    }

    private static Parameters createTlsParameters(SecurityConfig conf, CertificateClient caClient) {
        Parameters parameters = new Parameters();
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            GrpcTlsConfig serverConfig = new GrpcTlsConfig(caClient.getPrivateKey(), caClient.getCertificate(), caClient.getCACertificate(), true);
            GrpcConfigKeys.Server.setTlsConf((Parameters)parameters, (GrpcTlsConfig)serverConfig);
            GrpcConfigKeys.Admin.setTlsConf((Parameters)parameters, (GrpcTlsConfig)serverConfig);
            GrpcTlsConfig clientConfig = new GrpcTlsConfig(caClient.getPrivateKey(), caClient.getCertificate(), caClient.getCACertificate(), false);
            GrpcConfigKeys.Client.setTlsConf((Parameters)parameters, (GrpcTlsConfig)clientConfig);
        }
        return parameters;
    }

    @Override
    public void start() throws IOException {
        if (!this.isStarted) {
            LOG.info("Starting {} {}", (Object)this.getClass().getSimpleName(), (Object)this.server.getId());
            for (ThreadPoolExecutor executor : this.chunkExecutors) {
                executor.prestartAllCoreThreads();
            }
            this.server.start();
            RaftServerRpc serverRpc = this.server.getServerRpc();
            this.clientPort = this.getRealPort(serverRpc.getClientServerAddress(), DatanodeDetails.Port.Name.RATIS);
            this.adminPort = this.getRealPort(serverRpc.getAdminServerAddress(), DatanodeDetails.Port.Name.RATIS_ADMIN);
            this.serverPort = this.getRealPort(serverRpc.getInetSocketAddress(), DatanodeDetails.Port.Name.RATIS_SERVER);
            this.isStarted = true;
        }
    }

    private int getRealPort(InetSocketAddress address, DatanodeDetails.Port.Name name) {
        int realPort = address.getPort();
        this.datanodeDetails.setPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)name, (Integer)realPort));
        LOG.info("{} {} is started using port {} for {}", new Object[]{this.getClass().getSimpleName(), this.server.getId(), realPort, name});
        return realPort;
    }

    @Override
    public void stop() {
        if (this.isStarted) {
            try {
                this.server.close();
                for (ExecutorService executorService : this.chunkExecutors) {
                    executorService.shutdown();
                }
                this.isStarted = false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public int getIPCPort() {
        return this.clientPort;
    }

    @Override
    public HddsProtos.ReplicationType getServerType() {
        return HddsProtos.ReplicationType.RATIS;
    }

    @VisibleForTesting
    public RaftServer getServer() {
        return this.server;
    }

    public RaftServer.Division getServerDivision() throws IOException {
        return this.getServerDivision((RaftGroupId)this.server.getGroupIds().iterator().next());
    }

    public RaftServer.Division getServerDivision(RaftGroupId id) throws IOException {
        return this.server.getDivision(id);
    }

    private void processReply(RaftClientReply reply) throws IOException {
        NotLeaderException notLeaderException = reply.getNotLeaderException();
        if (notLeaderException != null) {
            throw notLeaderException;
        }
        StateMachineException stateMachineException = reply.getStateMachineException();
        if (stateMachineException != null) {
            throw stateMachineException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID) throws IOException {
        Span span = TracingUtil.importAndCreateSpan((String)("XceiverServerRatis." + request.getCmdType().name()), (String)request.getTraceID());
        try (Scope scope = GlobalTracer.get().activateSpan(span);){
            RaftClientReply reply;
            RaftClientRequest raftClientRequest = this.createRaftClientRequest(request, pipelineID, RaftClientRequest.writeRequestType());
            try {
                reply = (RaftClientReply)this.server.submitClientRequestAsync(raftClientRequest).get(this.requestTimeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
            this.processReply(reply);
        }
        finally {
            span.finish();
        }
    }

    private void initializeRatisVolumeMap() throws IOException {
        this.ratisVolumeMap = new EnumMap(StorageType.class);
        Collection rawLocations = HddsServerUtil.getOzoneDatanodeRatisDirectory((ConfigurationSource)this.conf);
        for (String locationString : rawLocations) {
            try {
                StorageLocation location = StorageLocation.parse((String)locationString);
                StorageType type = location.getStorageType();
                this.ratisVolumeMap.computeIfAbsent(type, k -> new ArrayList(1));
                this.ratisVolumeMap.get(location.getStorageType()).add(location.getUri().getPath());
            }
            catch (IOException e) {
                LOG.error("Failed to parse the storage location: " + locationString, (Throwable)e);
            }
        }
    }

    @Override
    public List<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto> getStorageReport() throws IOException {
        ArrayList<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto> reportProto = new ArrayList<StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto>();
        for (StorageType storageType : this.ratisVolumeMap.keySet()) {
            for (String path : this.ratisVolumeMap.get(storageType)) {
                StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto.Builder builder = StorageContainerDatanodeProtocolProtos.MetadataStorageReportProto.newBuilder();
                builder.setStorageLocation(path);
                builder.setStorageType(StorageLocationReport.getStorageTypeProto(storageType));
                reportProto.add(builder.build());
            }
        }
        return reportProto;
    }

    private RaftClientRequest createRaftClientRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID, RaftClientRequest.Type type) {
        return RaftClientRequest.newBuilder().setClientId(this.clientId).setServerId(this.server.getId()).setGroupId(RaftGroupId.valueOf((UUID)PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID).getId())).setCallId(XceiverServerRatis.nextCallId()).setMessage((Message)ContainerCommandRequestMessage.toMessage((ContainerProtos.ContainerCommandRequestProto)request, null)).setType(type).build();
    }

    private GroupInfoRequest createGroupInfoRequest(HddsProtos.PipelineID pipelineID) {
        return new GroupInfoRequest(this.clientId, this.server.getId(), RaftGroupId.valueOf((UUID)PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID).getId()), XceiverServerRatis.nextCallId());
    }

    private void handlePipelineFailure(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto) {
        String msg;
        UUID datanode = RatisHelper.toDatanodeId((RaftProtos.RaftPeerProto)roleInfoProto.getSelf());
        RaftPeerId id = RaftPeerId.valueOf((ByteString)roleInfoProto.getSelf().getId());
        switch (roleInfoProto.getRole()) {
            case CANDIDATE: {
                msg = datanode + " is in candidate state for " + roleInfoProto.getCandidateInfo().getLastLeaderElapsedTimeMs() + "ms";
                break;
            }
            case FOLLOWER: {
                msg = datanode + " closes pipeline when installSnapshot from leader because leader snapshot doesn't contain any data to replay, all the log entries prior to the snapshot might have been purged.So follower should not try to install snapshot from leader butcan close the pipeline here. It's in follower state for " + roleInfoProto.getRoleElapsedTimeMs() + "ms";
                break;
            }
            case LEADER: {
                StringBuilder sb = new StringBuilder();
                sb.append(datanode).append(" has not seen follower/s");
                for (RaftProtos.ServerRpcProto follower : roleInfoProto.getLeaderInfo().getFollowerInfoList()) {
                    if (follower.getLastRpcElapsedTimeMs() <= this.nodeFailureTimeoutMs) continue;
                    sb.append(" ").append(RatisHelper.toDatanodeId((RaftProtos.RaftPeerProto)follower.getId())).append(" for ").append(follower.getLastRpcElapsedTimeMs()).append("ms");
                }
                msg = sb.toString();
                break;
            }
            default: {
                LOG.error("unknown state: {}", (Object)roleInfoProto.getRole());
                throw new IllegalStateException("node" + id + " is in illegal role " + roleInfoProto.getRole());
            }
        }
        this.triggerPipelineClose(groupId, msg, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.PIPELINE_FAILED, false);
    }

    private void triggerPipelineClose(RaftGroupId groupId, String detail, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason reasonCode, boolean triggerHB) {
        PipelineID pipelineID = PipelineID.valueOf((UUID)groupId.getUuid());
        StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Builder closePipelineInfo = StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.newBuilder().setPipelineID(pipelineID.getProtobuf()).setReason(reasonCode).setDetailedReason(detail);
        StorageContainerDatanodeProtocolProtos.PipelineAction action = StorageContainerDatanodeProtocolProtos.PipelineAction.newBuilder().setClosePipeline(closePipelineInfo).setAction(StorageContainerDatanodeProtocolProtos.PipelineAction.Action.CLOSE).build();
        this.context.addPipelineActionIfAbsent(action);
        if (triggerHB) {
            this.context.getParent().triggerHeartbeat();
        }
        LOG.error("pipeline Action {} on pipeline {}.Reason : {}", new Object[]{action.getAction(), pipelineID, action.getClosePipeline().getDetailedReason()});
    }

    @Override
    public boolean isExist(HddsProtos.PipelineID pipelineId) {
        return this.raftGids.contains(RaftGroupId.valueOf((UUID)PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineId).getId()));
    }

    private long calculatePipelineBytesWritten(HddsProtos.PipelineID pipelineID) {
        long bytesWritten = 0L;
        Iterator<Container<?>> containerIt = this.containerController.getContainers();
        while (containerIt.hasNext()) {
            Object containerData = containerIt.next().getContainerData();
            if (((ContainerData)containerData).getOriginPipelineId().compareTo(pipelineID.getId()) != 0) continue;
            bytesWritten += ((ContainerData)containerData).getWriteBytes();
        }
        return bytesWritten;
    }

    @Override
    public List<StorageContainerDatanodeProtocolProtos.PipelineReport> getPipelineReport() {
        try {
            Iterable gids = this.server.getGroupIds();
            ArrayList<StorageContainerDatanodeProtocolProtos.PipelineReport> reports = new ArrayList<StorageContainerDatanodeProtocolProtos.PipelineReport>();
            for (RaftGroupId groupId : gids) {
                HddsProtos.PipelineID pipelineID = PipelineID.valueOf((UUID)groupId.getUuid()).getProtobuf();
                reports.add(StorageContainerDatanodeProtocolProtos.PipelineReport.newBuilder().setPipelineID(pipelineID).setIsLeader(this.groupLeaderMap.getOrDefault(groupId, Boolean.FALSE).booleanValue()).setBytesWritten(this.calculatePipelineBytesWritten(pipelineID)).build());
            }
            return reports;
        }
        catch (Exception e) {
            return null;
        }
    }

    @VisibleForTesting
    public List<PipelineID> getPipelineIds() {
        Iterable gids = this.server.getGroupIds();
        ArrayList<PipelineID> pipelineIDs = new ArrayList<PipelineID>();
        for (RaftGroupId groupId : gids) {
            pipelineIDs.add(PipelineID.valueOf((UUID)groupId.getUuid()));
            LOG.info("pipeline id {}", (Object)PipelineID.valueOf((UUID)groupId.getUuid()));
        }
        return pipelineIDs;
    }

    @Override
    public void addGroup(HddsProtos.PipelineID pipelineId, List<DatanodeDetails> peers) throws IOException {
        if (peers.size() == XceiverServerRatis.getDefaultPriorityList().size()) {
            this.addGroup(pipelineId, peers, XceiverServerRatis.getDefaultPriorityList());
        } else {
            this.addGroup(pipelineId, peers, new ArrayList<Integer>(Collections.nCopies(peers.size(), 0)));
        }
    }

    @Override
    public void addGroup(HddsProtos.PipelineID pipelineId, List<DatanodeDetails> peers, List<Integer> priorityList) throws IOException {
        RaftClientReply reply;
        PipelineID pipelineID = PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineId);
        RaftGroupId groupId = RaftGroupId.valueOf((UUID)pipelineID.getId());
        RaftGroup group = RatisHelper.newRaftGroup((RaftGroupId)groupId, peers, priorityList);
        GroupManagementRequest request = GroupManagementRequest.newAdd((ClientId)this.clientId, (RaftPeerId)this.server.getId(), (long)XceiverServerRatis.nextCallId(), (RaftGroup)group);
        try {
            reply = this.server.groupManagement(request);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        this.processReply(reply);
    }

    @Override
    public void removeGroup(HddsProtos.PipelineID pipelineId) throws IOException {
        RaftClientReply reply;
        GroupManagementRequest request = GroupManagementRequest.newRemove((ClientId)this.clientId, (RaftPeerId)this.server.getId(), (long)XceiverServerRatis.nextCallId(), (RaftGroupId)RaftGroupId.valueOf((UUID)PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineId).getId()), (boolean)this.shouldDeleteRatisLogDirectory, (!this.shouldDeleteRatisLogDirectory ? 1 : 0) != 0);
        try {
            reply = this.server.groupManagement(request);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        this.processReply(reply);
    }

    void handleNodeSlowness(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto) {
        this.handlePipelineFailure(groupId, roleInfoProto);
    }

    void handleNoLeader(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto) {
        this.handlePipelineFailure(groupId, roleInfoProto);
    }

    void handleApplyTransactionFailure(RaftGroupId groupId, RaftProtos.RaftPeerRole role) {
        UUID dnId = RatisHelper.toDatanodeId((RaftPeerId)this.getServer().getId());
        String msg = "Ratis Transaction failure in datanode " + dnId + " with role " + role + " .Triggering pipeline close action.";
        this.triggerPipelineClose(groupId, msg, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.STATEMACHINE_TRANSACTION_FAILED, true);
    }

    void handleInstallSnapshotFromLeader(RaftGroupId groupId, RaftProtos.RoleInfoProto roleInfoProto, TermIndex firstTermIndexInLog) {
        LOG.warn("Install snapshot notification received from Leader with termIndex: {}, terminating pipeline: {}", (Object)firstTermIndexInLog, (Object)groupId);
        this.handlePipelineFailure(groupId, roleInfoProto);
    }

    @VisibleForTesting
    public void handleNodeLogFailure(RaftGroupId groupId, Throwable t) {
        String msg = t == null ? "Unspecified failure reported in Ratis log" : t.getMessage();
        this.triggerPipelineClose(groupId, msg, StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.PIPELINE_LOG_FAILED, true);
    }

    public long getMinReplicatedIndex(PipelineID pipelineID) throws IOException {
        GroupInfoReply reply = this.getServer().getGroupInfo(this.createGroupInfoRequest(pipelineID.getProtobuf()));
        Long minIndex = RatisHelper.getMinReplicatedIndex((Collection)reply.getCommitInfos());
        return minIndex == null ? -1L : minIndex;
    }

    void notifyGroupRemove(RaftGroupId gid) {
        this.raftGids.remove(gid);
        this.groupLeaderMap.remove(gid);
    }

    void notifyGroupAdd(RaftGroupId gid) {
        this.raftGids.add(gid);
        this.sendPipelineReport();
    }

    void handleLeaderChangedNotification(RaftGroupMemberId groupMemberId, RaftPeerId raftPeerId1) {
        LOG.info("Leader change notification received for group: {} with new leaderId: {}", (Object)groupMemberId.getGroupId(), (Object)raftPeerId1);
        boolean leaderForGroup = this.raftPeerId.equals((Object)raftPeerId1);
        this.groupLeaderMap.put(groupMemberId.getGroupId(), leaderForGroup);
        if (this.context != null && leaderForGroup) {
            this.sendPipelineReport();
        }
    }

    private void sendPipelineReport() {
        if (this.context != null) {
            this.context.addReport((GeneratedMessage)this.context.getParent().getContainer().getPipelineReport());
            this.context.getParent().triggerHeartbeat();
        }
    }

    private static List<ThreadPoolExecutor> createChunkExecutors(ConfigurationSource conf) {
        int threadCountPerDisk = conf.getInt("dfs.container.ratis.num.write.chunk.threads.per.volume", 10);
        int numberOfDisks = MutableVolumeSet.getDatanodeStorageDirs(conf).size();
        Object[] executors = new ThreadPoolExecutor[threadCountPerDisk * numberOfDisks];
        for (int i = 0; i < executors.length; ++i) {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ChunkWriter-" + i + "-%d").build();
            LinkedBlockingDeque<Runnable> workQueue = new LinkedBlockingDeque<Runnable>();
            executors[i] = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, workQueue, threadFactory);
        }
        return ImmutableList.copyOf((Object[])executors);
    }

    public static List<Integer> getDefaultPriorityList() {
        return DEFAULT_PRIORITY_LIST;
    }
}

