/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import java.util.Map;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class DispatcherContext {
    private final WriteChunkStage stage;
    private final boolean readFromTmpFile;
    private final long term;
    private final long logIndex;
    private final Map<Long, Long> container2BCSIDMap;

    private DispatcherContext(long term, long index, WriteChunkStage stage, boolean readFromTmpFile, Map<Long, Long> container2BCSIDMap) {
        this.term = term;
        this.logIndex = index;
        this.stage = stage;
        this.readFromTmpFile = readFromTmpFile;
        this.container2BCSIDMap = container2BCSIDMap;
    }

    public long getLogIndex() {
        return this.logIndex;
    }

    public boolean isReadFromTmpFile() {
        return this.readFromTmpFile;
    }

    public long getTerm() {
        return this.term;
    }

    public WriteChunkStage getStage() {
        return this.stage;
    }

    public Map<Long, Long> getContainer2BCSIDMap() {
        return this.container2BCSIDMap;
    }

    public static final class Builder {
        private WriteChunkStage stage = WriteChunkStage.COMBINED;
        private boolean readFromTmpFile = false;
        private long term;
        private long logIndex;
        private Map<Long, Long> container2BCSIDMap;

        public Builder setStage(WriteChunkStage writeChunkStage) {
            this.stage = writeChunkStage;
            return this;
        }

        public Builder setReadFromTmpFile(boolean setReadFromTmpFile) {
            this.readFromTmpFile = setReadFromTmpFile;
            return this;
        }

        public Builder setTerm(long currentTerm) {
            this.term = currentTerm;
            return this;
        }

        public Builder setLogIndex(long index) {
            this.logIndex = index;
            return this;
        }

        public Builder setContainer2BCSIDMap(Map<Long, Long> map) {
            this.container2BCSIDMap = map;
            return this;
        }

        public DispatcherContext build() {
            return new DispatcherContext(this.term, this.logIndex, this.stage, this.readFromTmpFile, this.container2BCSIDMap);
        }
    }

    public static enum WriteChunkStage {
        WRITE_DATA,
        COMMIT_DATA,
        COMBINED;

    }
}

