/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.DeleteContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteContainerCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteContainerCommandHandler.class);
    private final AtomicInteger invocationCount = new AtomicInteger(0);
    private final AtomicLong totalTime = new AtomicLong(0L);
    private final ExecutorService executor;

    public DeleteContainerCommandHandler(int threadPoolSize) {
        this.executor = new ThreadPoolExecutor(0, threadPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DeleteContainerThread-%d").build());
    }

    @Override
    public void handle(SCMCommand command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        DeleteContainerCommand deleteContainerCommand = (DeleteContainerCommand)command;
        ContainerController controller = ozoneContainer.getController();
        this.executor.execute(() -> {
            long startTime = Time.monotonicNow();
            this.invocationCount.incrementAndGet();
            try {
                controller.deleteContainer(deleteContainerCommand.getContainerID(), deleteContainerCommand.isForce());
            }
            catch (IOException e) {
                LOG.error("Exception occurred while deleting the container.", (Throwable)e);
            }
            finally {
                this.totalTime.getAndAdd(Time.monotonicNow() - startTime);
            }
        });
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteContainerCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        int invocations = this.invocationCount.get();
        return invocations == 0 ? 0L : this.totalTime.get() / (long)invocations;
    }

    @Override
    public void stop() {
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }
}

