/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.CreatePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.exceptions.AlreadyExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePipelineCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CreatePipelineCommandHandler.class);
    private final AtomicLong invocationCount = new AtomicLong(0L);
    private final ConfigurationSource conf;
    private long totalTime;

    public CreatePipelineCommandHandler(ConfigurationSource conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SCMCommand command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        this.invocationCount.incrementAndGet();
        long startTime = Time.monotonicNow();
        DatanodeDetails dn = context.getParent().getDatanodeDetails();
        CreatePipelineCommand createCommand = (CreatePipelineCommand)command;
        PipelineID pipelineID = createCommand.getPipelineID();
        HddsProtos.PipelineID pipelineIdProto = pipelineID.getProtobuf();
        List<DatanodeDetails> peers = createCommand.getNodeList();
        List<Integer> priorityList = createCommand.getPriorityList();
        try {
            XceiverServerSpi server = ozoneContainer.getWriteChannel();
            if (!server.isExist(pipelineIdProto)) {
                RaftGroupId groupId = RaftGroupId.valueOf((UUID)pipelineID.getId());
                RaftGroup group = RatisHelper.newRaftGroup((RaftGroupId)groupId, peers, priorityList);
                server.addGroup(pipelineIdProto, peers, priorityList);
                peers.stream().filter(d -> !d.getUuid().equals(dn.getUuid())).forEach(d -> {
                    RaftPeer peer = RatisHelper.toRaftPeer((DatanodeDetails)d);
                    try (RaftClient client2 = RatisHelper.newRaftClient((RaftPeer)peer, (ConfigurationSource)this.conf, (GrpcTlsConfig)ozoneContainer.getTlsClientConfig());){
                        client2.getGroupManagementApi(peer.getId()).add(group);
                    }
                    catch (AlreadyExistsException client2) {
                    }
                    catch (IOException ioe) {
                        LOG.warn("Add group failed for {}", d, (Object)ioe);
                    }
                });
                LOG.info("Created Pipeline {} {} {}.", new Object[]{createCommand.getReplicationType(), createCommand.getFactor(), pipelineID});
            }
        }
        catch (IOException e) {
            LOG.error("Can't create pipeline {} {} {}", new Object[]{createCommand.getReplicationType(), createCommand.getFactor(), pipelineID, e});
        }
        finally {
            long endTime = Time.monotonicNow();
            this.totalTime += endTime - startTime;
        }
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.createPipelineCommand;
    }

    @Override
    public int getInvocationCount() {
        return (int)this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount.get() > 0L) {
            return this.totalTime / this.invocationCount.get();
        }
        return 0L;
    }
}

