/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import java.time.Duration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigGroup(prefix="hdds.datanode")
public class DatanodeConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeConfiguration.class);
    static final String REPLICATION_STREAMS_LIMIT_KEY = "hdds.datanode.replication.streams.limit";
    static final String CONTAINER_DELETE_THREADS_MAX_KEY = "hdds.datanode.container.delete.threads.max";
    static final int REPLICATION_MAX_STREAMS_DEFAULT = 10;
    @Config(key="replication.streams.limit", type=ConfigType.INT, defaultValue="10", tags={ConfigTag.DATANODE}, description="The maximum number of replication commands a single datanode can execute simultaneously")
    private int replicationMaxStreams = 10;
    static final int CONTAINER_DELETE_THREADS_DEFAULT = 2;
    @Config(key="container.delete.threads.max", type=ConfigType.INT, defaultValue="2", tags={ConfigTag.DATANODE}, description="The maximum number of threads used to delete containers on a datanode")
    private int containerDeleteThreads = 2;
    @Config(key="block.deleting.service.interval", defaultValue="60s", type=ConfigType.TIME, tags={ConfigTag.SCM, ConfigTag.DELETION}, description="Time interval of the Datanode block deleting service. The block deleting service runs on Datanode periodically and deletes blocks queued for deletion. Unit could be defined with postfix (ns,ms,s,m,h,d). ")
    private long blockDeletionInterval = Duration.ofSeconds(60L).toMillis();

    public Duration getBlockDeletionInterval() {
        return Duration.ofMillis(this.blockDeletionInterval);
    }

    public void setBlockDeletionInterval(Duration duration) {
        this.blockDeletionInterval = duration.toMillis();
    }

    @PostConstruct
    public void validate() {
        if (this.replicationMaxStreams < 1) {
            LOG.warn("hdds.datanode.replication.streams.limit must be greater than zero and was set to {}. Defaulting to {}", (Object)this.replicationMaxStreams, (Object)10);
            this.replicationMaxStreams = 10;
        }
        if (this.containerDeleteThreads < 1) {
            LOG.warn("hdds.datanode.container.delete.threads.max must be greater than zero and was set to {}. Defaulting to {}", (Object)this.containerDeleteThreads, (Object)2);
            this.containerDeleteThreads = 2;
        }
    }

    public void setReplicationMaxStreams(int replicationMaxStreams) {
        this.replicationMaxStreams = replicationMaxStreams;
    }

    public void setContainerDeleteThreads(int containerDeleteThreads) {
        this.containerDeleteThreads = containerDeleteThreads;
    }

    public int getReplicationMaxStreams() {
        return this.replicationMaxStreams;
    }

    public int getContainerDeleteThreads() {
        return this.containerDeleteThreads;
    }
}

