/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNOrderedContainerDeletionChoosingPolicy
implements ContainerDeletionChoosingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TopNOrderedContainerDeletionChoosingPolicy.class);
    private static final Comparator<KeyValueContainerData> KEY_VALUE_CONTAINER_DATA_COMPARATOR = (c1, c2) -> Long.compare(c2.getNumPendingDeletionBlocks(), c1.getNumPendingDeletionBlocks());

    @Override
    public List<ContainerData> chooseContainerForBlockDeletion(int count, Map<Long, ContainerData> candidateContainers) throws StorageContainerException {
        Preconditions.checkNotNull(candidateContainers, (Object)"Internal assertion: candidate containers cannot be null");
        LinkedList<ContainerData> result = new LinkedList<ContainerData>();
        LinkedList<KeyValueContainerData> orderedList = new LinkedList<KeyValueContainerData>();
        for (ContainerData entry : candidateContainers.values()) {
            orderedList.add((KeyValueContainerData)entry);
        }
        Collections.sort(orderedList, KEY_VALUE_CONTAINER_DATA_COMPARATOR);
        int currentCount = 0;
        for (KeyValueContainerData entry : orderedList) {
            if (currentCount >= count) break;
            if (entry.getNumPendingDeletionBlocks() > 0L) {
                result.add(entry);
                ++currentCount;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Select container {} for block deletion, pending deletion blocks num: {}.", (Object)entry.getContainerID(), (Object)entry.getNumPendingDeletionBlocks());
                continue;
            }
            LOG.debug("Stop looking for next container, there is no pending deletion block contained in remaining containers.");
            break;
        }
        return result;
    }
}

