/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.freon;

import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;

public final class FakeRatisFollower {
    private static int simulatedLatency = 0;

    private FakeRatisFollower() {
    }

    public static StreamObserver<RaftProtos.AppendEntriesRequestProto> appendEntries(final RaftPeerId raftPeerId, final StreamObserver<RaftProtos.AppendEntriesReplyProto> responseHandler) {
        return new StreamObserver<RaftProtos.AppendEntriesRequestProto>(){
            private long maxIndex = -1L;

            public void onNext(RaftProtos.AppendEntriesRequestProto value) {
                for (RaftProtos.LogEntryProto entry : value.getEntriesList()) {
                    if (entry.getIndex() <= this.maxIndex) continue;
                    this.maxIndex = entry.getIndex();
                }
                long maxCommitted = value.getCommitInfosList().stream().mapToLong(RaftProtos.CommitInfoProto::getCommitIndex).max().orElseGet(() -> 0L);
                maxCommitted = Math.min(maxCommitted, this.maxIndex);
                RaftProtos.AppendEntriesReplyProto response = RaftProtos.AppendEntriesReplyProto.newBuilder().setNextIndex(this.maxIndex + 1L).setFollowerCommit(maxCommitted).setResult(RaftProtos.AppendEntriesReplyProto.AppendResult.SUCCESS).setTerm(value.getLeaderTerm()).setMatchIndex(this.maxIndex).setServerReply(RaftProtos.RaftRpcReplyProto.newBuilder().setSuccess(true).setRequestorId(value.getServerRequest().getRequestorId()).setReplyId(raftPeerId.toByteString()).setCallId(value.getServerRequest().getCallId()).setRaftGroupId(value.getServerRequest().getRaftGroupId())).build();
                maxCommitted = Math.min(value.getLeaderCommit(), this.maxIndex);
                FakeRatisFollower.addLatency();
                responseHandler.onNext((Object)response);
            }

            public void onError(Throwable t) {
            }

            public void onCompleted() {
            }
        };
    }

    public static RaftProtos.RequestVoteReplyProto requestVote(RaftPeerId raftPeerId, RaftProtos.RequestVoteRequestProto request) {
        FakeRatisFollower.addLatency();
        System.out.println("Request vote response");
        return RaftProtos.RequestVoteReplyProto.newBuilder().setServerReply(RaftProtos.RaftRpcReplyProto.newBuilder().setSuccess(true).setRequestorId(request.getServerRequest().getRequestorId()).setReplyId(raftPeerId.toByteString()).setCallId(request.getServerRequest().getCallId()).setRaftGroupId(request.getServerRequest().getRaftGroupId())).setTerm(request.getCandidateTerm()).build();
    }

    private static void addLatency() {
        if (simulatedLatency > 0) {
            try {
                Thread.sleep(simulatedLatency);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        String ratisSimulatedLatency = System.getenv("RATIS_SIMULATED_LATENCY");
        if (ratisSimulatedLatency != null) {
            simulatedLatency = Integer.parseInt(ratisSimulatedLatency);
        }
    }
}

