/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.helpers.OmPartInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmMultipartUploadListParts {
    private HddsProtos.ReplicationType replicationType;
    private HddsProtos.ReplicationFactor replicationFactor;
    private int nextPartNumberMarker;
    private boolean truncated;
    private final List<OmPartInfo> partInfoList = new ArrayList<OmPartInfo>();

    public OmMultipartUploadListParts(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, int nextMarker, boolean truncate) {
        this.replicationType = type;
        this.replicationFactor = factor;
        this.nextPartNumberMarker = nextMarker;
        this.truncated = truncate;
    }

    public void addPart(OmPartInfo partInfo) {
        this.partInfoList.add(partInfo);
    }

    public HddsProtos.ReplicationType getReplicationType() {
        return this.replicationType;
    }

    public int getNextPartNumberMarker() {
        return this.nextPartNumberMarker;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public void setReplicationType(HddsProtos.ReplicationType replicationType) {
        this.replicationType = replicationType;
    }

    public List<OmPartInfo> getPartInfoList() {
        return this.partInfoList;
    }

    public HddsProtos.ReplicationFactor getReplicationFactor() {
        return this.replicationFactor;
    }

    public void addPartList(List<OmPartInfo> partInfos) {
        this.partInfoList.addAll(partInfos);
    }

    public void addProtoPartList(List<OzoneManagerProtocolProtos.PartInfo> partInfos) {
        partInfos.forEach(partInfo -> this.partInfoList.add(new OmPartInfo(partInfo.getPartNumber(), partInfo.getPartName(), partInfo.getModificationTime(), partInfo.getSize())));
    }
}

