/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.hdds.utils.BatchOperation;
import org.apache.hadoop.hdds.utils.EntryConsumer;
import org.apache.hadoop.hdds.utils.LevelDBStoreIterator;
import org.apache.hadoop.hdds.utils.MetaStoreIterator;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.MetadataStore;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LevelDBStore
implements MetadataStore {
    private static final Logger LOG = LoggerFactory.getLogger(LevelDBStore.class);
    private DB db;
    private final File dbFile;
    private final Options dbOptions;
    private final WriteOptions writeOptions;

    public LevelDBStore(File dbPath, boolean createIfMissing) throws IOException {
        this.dbOptions = new Options();
        this.dbOptions.createIfMissing(createIfMissing);
        this.dbFile = dbPath;
        this.writeOptions = new WriteOptions().sync(true);
        this.openDB(dbPath, this.dbOptions);
    }

    public LevelDBStore(File dbPath, Options options) throws IOException {
        this.dbOptions = options;
        this.dbFile = dbPath;
        this.writeOptions = new WriteOptions().sync(true);
        this.openDB(dbPath, this.dbOptions);
    }

    private void openDB(File dbPath, Options options) throws IOException {
        if (dbPath.getParentFile().mkdirs() && LOG.isDebugEnabled()) {
            LOG.debug("Db path {} created.", (Object)dbPath.getParentFile());
        }
        this.db = JniDBFactory.factory.open(dbPath, options);
        if (LOG.isDebugEnabled()) {
            LOG.debug("LevelDB successfully opened");
            LOG.debug("[Option] cacheSize = {}", (Object)options.cacheSize());
            LOG.debug("[Option] createIfMissing = {}", (Object)options.createIfMissing());
            LOG.debug("[Option] blockSize = {}", (Object)options.blockSize());
            LOG.debug("[Option] compressionType= {}", (Object)options.compressionType());
            LOG.debug("[Option] maxOpenFiles= {}", (Object)options.maxOpenFiles());
            LOG.debug("[Option] writeBufferSize= {}", (Object)options.writeBufferSize());
        }
    }

    @Override
    public void put(byte[] key, byte[] value) {
        this.db.put(key, value, this.writeOptions);
    }

    @Override
    public byte[] get(byte[] key) {
        return this.db.get(key);
    }

    @Override
    public void delete(byte[] key) {
        this.db.delete(key);
    }

    @Override
    public void close() throws IOException {
        if (this.db != null) {
            this.db.close();
        }
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (DBIterator iter = this.db.iterator();){
            boolean hasNext;
            iter.seekToFirst();
            boolean bl = hasNext = !iter.hasNext();
            return bl;
        }
    }

    public DB getDB() {
        return this.db;
    }

    public DBIterator getIterator() {
        return this.db.iterator();
    }

    @Override
    public void destroy() throws IOException {
        this.close();
        JniDBFactory.factory.destroy(this.dbFile, this.dbOptions);
    }

    @Override
    public ImmutablePair<byte[], byte[]> peekAround(int offset, byte[] from) throws IOException, IllegalArgumentException {
        try (DBIterator it = this.db.iterator();){
            if (from == null) {
                it.seekToFirst();
            } else {
                it.seek(from);
            }
            if (!it.hasNext()) {
                ImmutablePair<byte[], byte[]> immutablePair = null;
                return immutablePair;
            }
            switch (offset) {
                case 0: {
                    Map.Entry current = (Map.Entry)it.next();
                    ImmutablePair immutablePair = new ImmutablePair(current.getKey(), current.getValue());
                    return immutablePair;
                }
                case 1: {
                    if (it.next() != null && it.hasNext()) {
                        Map.Entry next = it.peekNext();
                        ImmutablePair immutablePair = new ImmutablePair(next.getKey(), next.getValue());
                        return immutablePair;
                    }
                    break;
                }
                case -1: {
                    if (it.hasPrev()) {
                        Map.Entry prev = it.peekPrev();
                        ImmutablePair immutablePair = new ImmutablePair(prev.getKey(), prev.getValue());
                        return immutablePair;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Position can only be -1, 0 or 1, but found " + offset);
                }
            }
        }
        return null;
    }

    @Override
    public void iterate(byte[] from, EntryConsumer consumer) throws IOException {
        try (DBIterator iter = this.db.iterator();){
            if (from != null) {
                iter.seek(from);
            } else {
                iter.seekToFirst();
            }
            while (iter.hasNext()) {
                Map.Entry current = (Map.Entry)iter.next();
                if (consumer.consume((byte[])current.getKey(), (byte[])current.getValue())) continue;
                break;
            }
        }
    }

    @Override
    public void compactDB() throws IOException {
        if (this.db != null) {
            this.db.compactRange(null, null);
        }
    }

    @Override
    public void flushDB(boolean sync) {
    }

    @Override
    public void writeBatch(BatchOperation operation) throws IOException {
        List operations = operation.getOperations();
        if (!operations.isEmpty()) {
            try (WriteBatch writeBatch = this.db.createWriteBatch();){
                block13: for (BatchOperation.SingleOperation opt : operations) {
                    switch (opt.getOpt()) {
                        case DELETE: {
                            writeBatch.delete(opt.getKey());
                            continue block13;
                        }
                        case PUT: {
                            writeBatch.put(opt.getKey(), opt.getValue());
                            continue block13;
                        }
                    }
                    throw new IllegalArgumentException("Invalid operation " + opt.getOpt());
                }
                this.db.write(writeBatch);
            }
        }
    }

    @Override
    public List<Map.Entry<byte[], byte[]>> getRangeKVs(byte[] startKey, int count, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.getRangeKVs(startKey, count, false, filters);
    }

    @Override
    public List<Map.Entry<byte[], byte[]>> getSequentialRangeKVs(byte[] startKey, int count, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException, IllegalArgumentException {
        return this.getRangeKVs(startKey, count, true, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private List<Map.Entry<byte[], byte[]>> getRangeKVs(byte[] startKey, int count, boolean sequential, MetadataKeyFilters.MetadataKeyFilter ... filters) throws IOException {
        block25: {
            block23: {
                block24: {
                    block26: {
                        result = new ArrayList<Map.Entry<byte[], byte[]>>();
                        start = System.currentTimeMillis();
                        if (count < 0) {
                            throw new IllegalArgumentException("Invalid count given " + count + ", count must be greater than 0");
                        }
                        snapShot = null;
                        dbIter = null;
                        snapShot = this.db.getSnapshot();
                        readOptions = new ReadOptions().snapshot(snapShot);
                        dbIter = this.db.iterator((ReadOptions)readOptions);
                        if (startKey != null) break block26;
                        dbIter.seekToFirst();
                        ** GOTO lbl38
                    }
                    if (this.db.get(startKey) != null) break block23;
                    var11_11 = result;
                    if (snapShot == null) break block24;
                    snapShot.close();
                }
                if (dbIter != null) {
                    dbIter.close();
                }
                if (LevelDBStore.LOG.isDebugEnabled()) {
                    if (filters != null) {
                        for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                            scanned = filter.getKeysScannedNum();
                            hinted = filter.getKeysHintedNum();
                            if (scanned <= 0 && hinted <= 0 || !LevelDBStore.LOG.isDebugEnabled()) continue;
                            LevelDBStore.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                        }
                    }
                    end = System.currentTimeMillis();
                    timeConsumed = end - start;
                    if (LevelDBStore.LOG.isDebugEnabled()) {
                        LevelDBStore.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                    }
                }
                return var11_11;
            }
            try {
                dbIter.seek(startKey);
lbl38:
                // 5 sources

                while (dbIter.hasNext() && result.size() < count) {
                    preKey = dbIter.hasPrev() != false ? (byte[])dbIter.peekPrev().getKey() : null;
                    nextKey = dbIter.hasNext() != false ? (byte[])dbIter.peekNext().getKey() : null;
                    current = (Map.Entry)dbIter.next();
                    if (filters == null) {
                        result.add(current);
                        continue;
                    }
                    if (Arrays.asList(filters).stream().allMatch((Predicate<MetadataKeyFilters.MetadataKeyFilter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getRangeKVs$0(byte[] java.util.Map$Entry byte[] org.apache.hadoop.hdds.utils.MetadataKeyFilters$MetadataKeyFilter ), (Lorg/apache/hadoop/hdds/utils/MetadataKeyFilters$MetadataKeyFilter;)Z)((byte[])preKey, (Map.Entry)current, (byte[])nextKey))) {
                        result.add(current);
                        continue;
                    }
                    if (result.size() <= 0 || !sequential) continue;
                    break;
                }
                if (snapShot == null) break block25;
            }
            catch (Throwable var18_28) {
                if (snapShot != null) {
                    snapShot.close();
                }
                if (dbIter != null) {
                    dbIter.close();
                }
                if (LevelDBStore.LOG.isDebugEnabled()) {
                    if (filters != null) {
                        for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                            scanned = filter.getKeysScannedNum();
                            hinted = filter.getKeysHintedNum();
                            if (scanned <= 0 && hinted <= 0 || !LevelDBStore.LOG.isDebugEnabled()) continue;
                            LevelDBStore.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                        }
                    }
                    end = System.currentTimeMillis();
                    timeConsumed = end - start;
                    if (LevelDBStore.LOG.isDebugEnabled()) {
                        LevelDBStore.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
                    }
                }
                throw var18_28;
            }
            snapShot.close();
        }
        if (dbIter != null) {
            dbIter.close();
        }
        if (LevelDBStore.LOG.isDebugEnabled()) {
            if (filters != null) {
                for (MetadataKeyFilters.MetadataKeyFilter filter : filters) {
                    scanned = filter.getKeysScannedNum();
                    hinted = filter.getKeysHintedNum();
                    if (scanned <= 0 && hinted <= 0 || !LevelDBStore.LOG.isDebugEnabled()) continue;
                    LevelDBStore.LOG.debug("getRangeKVs ({}) numOfKeysScanned={}, numOfKeysHinted={}", new Object[]{filter.getClass().getSimpleName(), filter.getKeysScannedNum(), filter.getKeysHintedNum()});
                }
            }
            end = System.currentTimeMillis();
            timeConsumed = end - start;
            if (LevelDBStore.LOG.isDebugEnabled()) {
                LevelDBStore.LOG.debug("Time consumed for getRangeKVs() is {}ms, result length is {}.", (Object)timeConsumed, (Object)result.size());
            }
        }
        return result;
    }

    @Override
    public MetaStoreIterator<MetadataStore.KeyValue> iterator() {
        return new LevelDBStoreIterator(this.db.iterator());
    }

    private static /* synthetic */ boolean lambda$getRangeKVs$0(byte[] preKey, Map.Entry current, byte[] nextKey, MetadataKeyFilters.MetadataKeyFilter entry) {
        return entry.filterKey(preKey, (byte[])current.getKey(), nextKey);
    }
}

