/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Collections;
import java.util.List;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.Preconditions;

public class SetConfigurationRequest
extends RaftClientRequest {
    private final List<RaftPeer> peers;

    public SetConfigurationRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, List<RaftPeer> peers) {
        super(clientId, serverId, groupId, callId, SetConfigurationRequest.writeRequestType());
        this.peers = peers != null ? Collections.unmodifiableList(peers) : Collections.emptyList();
        Preconditions.assertUnique(this.peers);
    }

    public List<RaftPeer> getPeersInNewConf() {
        return this.peers;
    }

    @Override
    public String toString() {
        return super.toString() + ", peers:" + this.getPeersInNewConf();
    }
}

