/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List containers"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListSubcommand
extends ScmSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(ListSubcommand.class);
    @CommandLine.Option(names={"-s", "--start"}, description={"Container id to start the iteration"})
    private long startId;
    @CommandLine.Option(names={"-c", "--count"}, description={"Maximum number of containers to list"}, defaultValue="20", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int count;
    @CommandLine.Option(names={"--state"}, description={"Container state(OPEN, CLOSING, QUASI_CLOSED, CLOSED, DELETING, DELETED)"})
    private HddsProtos.LifeCycleState state;
    private static final ObjectWriter WRITER;

    private void outputContainerInfo(ContainerInfo containerInfo) throws IOException {
        LOG.info("{}", (Object)WRITER.writeValueAsString((Object)containerInfo));
    }

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        List containerList = scmClient.listContainer(this.startId, this.count, this.state);
        for (ContainerInfo container : containerList) {
            this.outputContainerInfo(container);
        }
    }

    static {
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }
}

