/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.GenericParentCommand;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="info", description={"Show information about a specific container"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class InfoSubcommand
extends ScmSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(InfoSubcommand.class);
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;
    @CommandLine.Parameters(description={"Decimal id of the container."})
    private long containerID;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        ContainerWithPipeline container = scmClient.getContainerWithPipeline(this.containerID);
        Preconditions.checkNotNull((Object)container, (Object)"Container cannot be null");
        if (this.json) {
            LOG.info(JsonUtils.toJsonStringWithDefaultPrettyPrinter((Object)container));
        } else {
            boolean verbose;
            LOG.info("Container id: {}", (Object)this.containerID);
            boolean bl = verbose = this.spec.root().userObject() instanceof GenericParentCommand && ((GenericParentCommand)this.spec.root().userObject()).isVerbose();
            if (verbose) {
                LOG.info("Pipeline Info: {}", (Object)container.getPipeline());
            } else {
                LOG.info("Pipeline id: {}", (Object)container.getPipeline().getId().getId());
            }
            LOG.info("Container State: {}", (Object)container.getContainerInfo().getState());
            String machinesStr = container.getPipeline().getNodes().stream().map(InfoSubcommand::buildDatanodeDetails).collect(Collectors.joining(",\n"));
            LOG.info("Datanodes: [{}]", (Object)machinesStr);
        }
    }

    private static String buildDatanodeDetails(DatanodeDetails details) {
        return details.getUuidString() + "/" + details.getHostName();
    }
}

