/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.cert;

import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.cert.ScmCertSubcommand;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List certificates"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListSubcommand
extends ScmCertSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(ListSubcommand.class);
    @CommandLine.Option(names={"-s", "--start"}, description={"Certificate serial id to start the iteration"}, defaultValue="0", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private long startSerialId;
    @CommandLine.Option(names={"-c", "--count"}, description={"Maximum number of certificates to list"}, defaultValue="20", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private int count;
    @CommandLine.Option(names={"-r", "--role"}, description={"Filter certificate by the role: om/datanode"}, defaultValue="datanode", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String role;
    @CommandLine.Option(names={"-t", "--type"}, description={"Filter certificate by the type: valid or revoked"}, defaultValue="valid", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String type;
    private static final String OUTPUT_FORMAT = "%-17s %-30s %-30s %-110s";

    private HddsProtos.NodeType parseCertRole(String r) {
        if (r.equalsIgnoreCase("om")) {
            return HddsProtos.NodeType.OM;
        }
        if (r.equalsIgnoreCase("scm")) {
            return HddsProtos.NodeType.SCM;
        }
        return HddsProtos.NodeType.DATANODE;
    }

    private void printCert(X509Certificate cert) {
        LOG.info(String.format(OUTPUT_FORMAT, cert.getSerialNumber(), cert.getNotBefore(), cert.getNotAfter(), cert.getSubjectDN()));
    }

    @Override
    protected void execute(SCMSecurityProtocol client) throws IOException {
        boolean isRevoked = this.type.equalsIgnoreCase("revoked");
        List certPemList = client.listCertificate(this.parseCertRole(this.role), this.startSerialId, this.count, isRevoked);
        LOG.info("Total {} {} certificates: ", (Object)certPemList.size(), (Object)this.type);
        LOG.info(String.format(OUTPUT_FORMAT, "SerialNumber", "Valid From", "Expiry", "Subject"));
        for (String certPemStr : certPemList) {
            try {
                X509Certificate cert = CertificateCodec.getX509Certificate((String)certPemStr);
                this.printCert(cert);
            }
            catch (CertificateException ex) {
                LOG.error("Failed to parse certificate.");
            }
        }
    }
}

