/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmOption;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="wait", description={"Wait until the scm is out from the safe mode."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class SafeModeWaitSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(SafeModeWaitSubcommand.class);
    @CommandLine.Option(description={"Define timeout (in second) to wait until (exit code 1) or until safemode is ended (exit code 0)."}, defaultValue="30", names={"-t", "--timeout"})
    private long timeoutSeconds;
    private long startTestTime;
    @CommandLine.Mixin
    private ScmOption scmOption;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() throws Exception {
        this.startTestTime = System.currentTimeMillis();
        while (this.getRemainingTimeInSec() > 0L) {
            try {
                ScmClient scmClient = this.scmOption.createScmClient();
                Throwable throwable = null;
                try {
                    long remainingTime;
                    do {
                        if (!scmClient.inSafeMode()) {
                            LOG.info("SCM is out of safe mode.");
                            Void void_ = null;
                            return void_;
                        }
                        remainingTime = this.getRemainingTimeInSec();
                        if (remainingTime > 0L) {
                            LOG.info("SCM is in safe mode. Will retry in 1 sec. Remaining time (sec): {}", (Object)remainingTime);
                            Thread.sleep(1000L);
                            continue;
                        }
                        LOG.info("SCM is in safe mode. No more retries.");
                    } while (remainingTime > 0L);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scmClient == null) continue;
                    if (throwable != null) {
                        try {
                            scmClient.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    scmClient.close();
                }
            }
            catch (Exception ex) {
                LOG.info("SCM is not available (yet?). Error is {}. Will retry in 1 sec. Remaining time (sec): {}", (Object)ex.getMessage(), (Object)this.getRemainingTimeInSec());
                Thread.sleep(1000L);
            }
        }
        throw new TimeoutException("Safe mode is not ended within the timeout period.");
    }

    private long getRemainingTimeInSec() {
        return this.timeoutSeconds - (System.currentTimeMillis() - this.startTestTime) / 1000L;
    }
}

