/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc;

import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;

public class GrpcTlsConfig {
    private PrivateKey privateKey;
    private File privateKeyFile;
    private X509Certificate certChain;
    private File certChainFile;
    private List<X509Certificate> trustStore;
    private File trustStoreFile;
    private final boolean mTlsEnabled;
    private final boolean fileBasedConfig;

    public boolean isFileBasedConfig() {
        return this.fileBasedConfig;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public File getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public X509Certificate getCertChain() {
        return this.certChain;
    }

    public File getCertChainFile() {
        return this.certChainFile;
    }

    public List<X509Certificate> getTrustStore() {
        return this.trustStore;
    }

    public File getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public boolean getMtlsEnabled() {
        return this.mTlsEnabled;
    }

    public GrpcTlsConfig(PrivateKey privateKey, X509Certificate certChain, List<X509Certificate> trustStore, boolean mTlsEnabled) {
        this.privateKey = privateKey;
        this.certChain = certChain;
        this.trustStore = trustStore;
        this.mTlsEnabled = mTlsEnabled;
        this.fileBasedConfig = false;
    }

    public GrpcTlsConfig(PrivateKey privateKey, X509Certificate certChain, X509Certificate trustStore, boolean mTlsEnabled) {
        this.privateKey = privateKey;
        this.certChain = certChain;
        this.trustStore = Collections.singletonList(trustStore);
        this.mTlsEnabled = mTlsEnabled;
        this.fileBasedConfig = false;
    }

    public GrpcTlsConfig(File privateKeyFile, File certChainFile, File trustStoreFile, boolean mTlsEnabled) {
        this.privateKeyFile = privateKeyFile;
        this.certChainFile = certChainFile;
        this.trustStoreFile = trustStoreFile;
        this.mTlsEnabled = mTlsEnabled;
        this.fileBasedConfig = true;
    }
}

