/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.XceiverClientProtocolServiceGrpc;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.XceiverClientMetrics;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.CheckedBiFunction;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.tracing.GrpcClientInterceptor;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.ClientInterceptor;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.netty.GrpcSslContexts;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.thirdparty.io.netty.handler.ssl.SslContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XceiverClientGrpc
extends XceiverClientSpi {
    static final Logger LOG = LoggerFactory.getLogger(XceiverClientGrpc.class);
    private final Pipeline pipeline;
    private final ConfigurationSource config;
    private Map<UUID, XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub> asyncStubs;
    private XceiverClientMetrics metrics;
    private Map<UUID, ManagedChannel> channels;
    private final Semaphore semaphore;
    private boolean closed = false;
    private final long timeout;
    private SecurityConfig secConfig;
    private final boolean topologyAwareRead;
    private X509Certificate caCert;
    private Map<ContainerProtos.DatanodeBlockID, DatanodeDetails> getBlockDNcache;

    public XceiverClientGrpc(Pipeline pipeline, ConfigurationSource config, X509Certificate caCert) {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkNotNull((Object)config);
        this.timeout = config.getTimeDuration("ozone.client.read.timeout", "30s", TimeUnit.SECONDS);
        this.pipeline = pipeline;
        this.config = config;
        this.secConfig = new SecurityConfig(config);
        this.semaphore = new Semaphore(HddsClientUtils.getMaxOutstandingRequests(config));
        this.metrics = XceiverClientManager.getXceiverClientMetrics();
        this.channels = new HashMap<UUID, ManagedChannel>();
        this.asyncStubs = new HashMap<UUID, XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub>();
        this.topologyAwareRead = config.getBoolean("ozone.network.topology.aware.read", false);
        this.caCert = caCert;
        this.getBlockDNcache = new ConcurrentHashMap<ContainerProtos.DatanodeBlockID, DatanodeDetails>();
    }

    public XceiverClientGrpc(Pipeline pipeline, ConfigurationSource config) {
        this(pipeline, config, null);
    }

    public void connect() throws Exception {
        DatanodeDetails dn = this.topologyAwareRead ? this.pipeline.getClosestNode() : this.pipeline.getFirstNode();
        this.connectToDatanode(dn);
    }

    public void connect(String encodedToken) throws Exception {
        DatanodeDetails dn = this.topologyAwareRead ? this.pipeline.getClosestNode() : this.pipeline.getFirstNode();
        this.connectToDatanode(dn);
    }

    private synchronized void connectToDatanode(DatanodeDetails dn) throws IOException {
        if (this.isConnected(dn)) {
            return;
        }
        int port = dn.getPort(DatanodeDetails.Port.Name.STANDALONE).getValue();
        if (port == 0) {
            port = this.config.getInt("dfs.container.ipc", 9859);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Nodes in pipeline : {}", (Object)this.pipeline.getNodes());
            LOG.debug("Connecting to server : {}", (Object)dn.getIpAddress());
        }
        NettyChannelBuilder channelBuilder = (NettyChannelBuilder)NettyChannelBuilder.forAddress((String)dn.getIpAddress(), (int)port).usePlaintext().maxInboundMessageSize(0x2000000).intercept(new ClientInterceptor[]{new GrpcClientInterceptor()});
        if (this.secConfig.isGrpcTlsEnabled()) {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (this.caCert != null) {
                sslContextBuilder.trustManager(new X509Certificate[]{this.caCert});
            }
            if (this.secConfig.useTestCert()) {
                channelBuilder.overrideAuthority("localhost");
            }
            channelBuilder.useTransportSecurity().sslContext(sslContextBuilder.build());
        } else {
            channelBuilder.usePlaintext();
        }
        ManagedChannel channel = channelBuilder.build();
        XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub asyncStub = XceiverClientProtocolServiceGrpc.newStub((Channel)channel);
        this.asyncStubs.put(dn.getUuid(), asyncStub);
        this.channels.put(dn.getUuid(), channel);
    }

    @VisibleForTesting
    public boolean isConnected(DatanodeDetails details) {
        return this.isConnected(this.channels.get(details.getUuid()));
    }

    private boolean isConnected(ManagedChannel channel) {
        return channel != null && !channel.isTerminated() && !channel.isShutdown();
    }

    public synchronized void close() {
        this.closed = true;
        for (ManagedChannel channel : this.channels.values()) {
            channel.shutdownNow();
            try {
                channel.awaitTermination(60L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while waiting for channel termination", (Throwable)e);
            }
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto request) throws IOException {
        try {
            return (ContainerProtos.ContainerCommandResponseProto)this.sendCommandWithTraceIDAndRetry(request, null).getResponse().get();
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to execute command " + request, e);
        }
        catch (InterruptedException e) {
            LOG.error("Command execution was interrupted.");
            Thread.currentThread().interrupt();
            throw (IOException)new InterruptedIOException("Command " + request + " was interrupted.").initCause(e);
        }
    }

    public Map<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> sendCommandOnAllNodes(ContainerProtos.ContainerCommandRequestProto request) throws IOException {
        HashMap<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> responseProtoHashMap = new HashMap<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto>();
        List datanodeList = this.pipeline.getNodes();
        HashMap<DatanodeDetails, CompletableFuture> futureHashMap = new HashMap<DatanodeDetails, CompletableFuture>();
        for (DatanodeDetails datanodeDetails : datanodeList) {
            try {
                futureHashMap.put(datanodeDetails, this.sendCommandAsync(request, datanodeDetails).getResponse());
            }
            catch (InterruptedException e) {
                LOG.error("Command execution was interrupted.");
            }
        }
        try {
            for (Map.Entry entry : futureHashMap.entrySet()) {
                responseProtoHashMap.put((DatanodeDetails)entry.getKey(), (ContainerProtos.ContainerCommandResponseProto)((CompletableFuture)entry.getValue()).get());
            }
        }
        catch (InterruptedException e) {
            LOG.error("Command execution was interrupted.");
        }
        catch (ExecutionException e) {
            LOG.error("Failed to execute command " + request, (Throwable)e);
        }
        return responseProtoHashMap;
    }

    public ContainerProtos.ContainerCommandResponseProto sendCommand(ContainerProtos.ContainerCommandRequestProto request, List<CheckedBiFunction> validators) throws IOException {
        try {
            XceiverClientReply reply = this.sendCommandWithTraceIDAndRetry(request, validators);
            return (ContainerProtos.ContainerCommandResponseProto)reply.getResponse().get();
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to execute command " + request, e);
        }
        catch (InterruptedException e) {
            LOG.error("Command execution was interrupted.");
            Thread.currentThread().interrupt();
            throw (IOException)new InterruptedIOException("Command " + request + " was interrupted.").initCause(e);
        }
    }

    private XceiverClientReply sendCommandWithTraceIDAndRetry(ContainerProtos.ContainerCommandRequestProto request, List<CheckedBiFunction> validators) throws IOException {
        String spanName = "XceiverClientGrpc." + request.getCmdType().name();
        return (XceiverClientReply)TracingUtil.executeInNewSpan((String)spanName, () -> {
            ContainerProtos.ContainerCommandRequestProto finalPayload = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)request).setTraceID(TracingUtil.exportCurrentSpan()).build();
            return this.sendCommandWithRetry(finalPayload, validators);
        });
    }

    private XceiverClientReply sendCommandWithRetry(ContainerProtos.ContainerCommandRequestProto request, List<CheckedBiFunction> validators) throws IOException {
        int getBlockDNCacheIndex;
        DatanodeDetails cachedDN;
        ContainerProtos.ContainerCommandResponseProto responseProto = null;
        IOException ioException = null;
        XceiverClientReply reply = new XceiverClientReply(null);
        List datanodeList = null;
        ContainerProtos.DatanodeBlockID blockID = null;
        if (request.getCmdType() == ContainerProtos.Type.GetBlock) {
            blockID = request.getGetBlock().getBlockID();
        } else if (request.getCmdType() == ContainerProtos.Type.ReadChunk) {
            blockID = request.getReadChunk().getBlockID();
        } else if (request.getCmdType() == ContainerProtos.Type.GetSmallFile) {
            blockID = request.getGetSmallFile().getBlock().getBlockID();
        }
        if (blockID != null && (cachedDN = this.getBlockDNcache.get(blockID)) != null && (getBlockDNCacheIndex = (datanodeList = this.pipeline.getNodes()).indexOf(cachedDN)) > 0) {
            Collections.swap(datanodeList, 0, getBlockDNCacheIndex);
        }
        if (datanodeList == null) {
            if (this.topologyAwareRead) {
                datanodeList = this.pipeline.getNodesInOrder();
            } else {
                datanodeList = this.pipeline.getNodes();
                Collections.shuffle(datanodeList);
            }
        }
        for (DatanodeDetails dn : datanodeList) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executing command {} on datanode {}", (Object)request, (Object)dn);
                }
                reply.addDatanode(dn);
                responseProto = (ContainerProtos.ContainerCommandResponseProto)this.sendCommandAsync(request, dn).getResponse().get();
                if (validators != null && !validators.isEmpty()) {
                    for (CheckedBiFunction validator : validators) {
                        validator.apply((Object)request, (Object)responseProto);
                    }
                }
                if (request.getCmdType() != ContainerProtos.Type.GetBlock) break;
                ContainerProtos.DatanodeBlockID getBlockID = request.getGetBlock().getBlockID();
                this.getBlockDNcache.put(getBlockID, dn);
                break;
            }
            catch (IOException e) {
                ioException = e;
                responseProto = null;
            }
            catch (ExecutionException e) {
                LOG.debug("Failed to execute command {} on datanode {}", new Object[]{request, dn, e});
                if (Status.fromThrowable((Throwable)e.getCause()).getCode() == Status.UNAUTHENTICATED.getCode()) {
                    throw new SCMSecurityException("Failed to authenticate with GRPC XceiverServer with Ozone block token.");
                }
                ioException = new IOException(e);
                responseProto = null;
            }
            catch (InterruptedException e) {
                LOG.error("Command execution was interrupted ", (Throwable)e);
                Thread.currentThread().interrupt();
                responseProto = null;
            }
        }
        if (responseProto != null) {
            reply.setResponse(CompletableFuture.completedFuture(responseProto));
            return reply;
        }
        Preconditions.checkNotNull(ioException);
        LOG.error("Failed to execute command {} on the pipeline {}.", (Object)request, (Object)this.pipeline);
        throw ioException;
    }

    /*
     * Loose catch block
     */
    public XceiverClientReply sendCommandAsync(ContainerProtos.ContainerCommandRequestProto request) throws IOException, ExecutionException, InterruptedException {
        Span span = GlobalTracer.get().buildSpan("XceiverClientGrpc." + request.getCmdType().name()).start();
        try {
            try (Scope scope = GlobalTracer.get().activateSpan(span);){
                ContainerProtos.ContainerCommandRequestProto finalPayload = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)request).setTraceID(TracingUtil.exportCurrentSpan()).build();
                XceiverClientReply asyncReply = this.sendCommandAsync(finalPayload, this.pipeline.getFirstNode());
                if (!HddsUtils.isReadOnly((ContainerProtos.ContainerCommandRequestProto)request)) {
                    asyncReply.getResponse().get();
                }
                XceiverClientReply xceiverClientReply = asyncReply;
                return xceiverClientReply;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    @VisibleForTesting
    public XceiverClientReply sendCommandAsync(final ContainerProtos.ContainerCommandRequestProto request, final DatanodeDetails dn) throws IOException, InterruptedException {
        this.checkOpen(dn, request.getEncodedToken());
        UUID dnId = dn.getUuid();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send command {} to datanode {}", (Object)request.getCmdType(), (Object)dn.getIpAddress());
        }
        final CompletableFuture replyFuture = new CompletableFuture();
        this.semaphore.acquire();
        final long requestTime = System.currentTimeMillis();
        this.metrics.incrPendingContainerOpsMetrics(request.getCmdType());
        StreamObserver requestObserver = ((XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceStub)this.asyncStubs.get(dnId).withDeadlineAfter(this.timeout, TimeUnit.SECONDS)).send((StreamObserver)new StreamObserver<ContainerProtos.ContainerCommandResponseProto>(){

            public void onNext(ContainerProtos.ContainerCommandResponseProto value) {
                replyFuture.complete(value);
                XceiverClientGrpc.this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
                long cost = System.currentTimeMillis() - requestTime;
                XceiverClientGrpc.this.metrics.addContainerOpsLatency(request.getCmdType(), cost);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executed command {} on datanode {}, cost = {}, cmdType = {}", new Object[]{request, dn, cost, request.getCmdType()});
                }
                XceiverClientGrpc.this.semaphore.release();
            }

            public void onError(Throwable t) {
                replyFuture.completeExceptionally(t);
                XceiverClientGrpc.this.metrics.decrPendingContainerOpsMetrics(request.getCmdType());
                long cost = System.currentTimeMillis() - requestTime;
                XceiverClientGrpc.this.metrics.addContainerOpsLatency(request.getCmdType(), System.currentTimeMillis() - requestTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Executed command {} on datanode {}, cost = {}, cmdType = {}", new Object[]{request, dn, cost, request.getCmdType()});
                }
                XceiverClientGrpc.this.semaphore.release();
            }

            public void onCompleted() {
                if (!replyFuture.isDone()) {
                    replyFuture.completeExceptionally(new IOException("Stream completed but no reply for request " + request));
                }
            }
        });
        requestObserver.onNext((Object)request);
        requestObserver.onCompleted();
        return new XceiverClientReply(replyFuture);
    }

    private synchronized void checkOpen(DatanodeDetails dn, String encodedToken) throws IOException {
        if (this.closed) {
            throw new IOException("This channel is not connected.");
        }
        ManagedChannel channel = this.channels.get(dn.getUuid());
        if (!this.isConnected(channel)) {
            this.reconnect(dn, encodedToken);
        }
    }

    private void reconnect(DatanodeDetails dn, String encodedToken) throws IOException {
        ManagedChannel channel;
        try {
            this.connectToDatanode(dn);
            channel = this.channels.get(dn.getUuid());
        }
        catch (Exception e) {
            throw new IOException("Error while connecting", e);
        }
        if (channel == null || !this.isConnected(channel)) {
            throw new IOException("This channel is not connected.");
        }
    }

    public XceiverClientReply watchForCommit(long index) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        return null;
    }

    public long getReplicatedMinCommitIndex() {
        return 0L;
    }

    public HddsProtos.ReplicationType getPipelineType() {
        return HddsProtos.ReplicationType.STAND_ALONE;
    }
}

