/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.ozone.client.io.BlockOutputStreamEntry;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOutputStreamEntryPool {
    public static final Logger LOG = LoggerFactory.getLogger(BlockOutputStreamEntryPool.class);
    private final List<BlockOutputStreamEntry> streamEntries;
    private final OzoneClientConfig config;
    private int currentStreamIndex;
    private final OzoneManagerProtocol omClient;
    private final OmKeyArgs keyArgs;
    private final XceiverClientFactory xceiverClientFactory;
    private final String requestID;
    private final BufferPool bufferPool;
    private OmMultipartCommitUploadPartInfo commitUploadPartInfo;
    private final long openID;
    private final ExcludeList excludeList;

    public BlockOutputStreamEntryPool(OzoneClientConfig config, OzoneManagerProtocol omClient, String requestId, HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType type, String uploadID, int partNumber, boolean isMultipart, OmKeyInfo info, boolean unsafeByteBufferConversion, XceiverClientFactory xceiverClientFactory, long openID) {
        this.config = config;
        this.xceiverClientFactory = xceiverClientFactory;
        this.streamEntries = new ArrayList<BlockOutputStreamEntry>();
        this.currentStreamIndex = 0;
        this.omClient = omClient;
        this.keyArgs = new OmKeyArgs.Builder().setVolumeName(info.getVolumeName()).setBucketName(info.getBucketName()).setKeyName(info.getKeyName()).setType(type).setFactor(factor).setDataSize(info.getDataSize()).setIsMultipartKey(isMultipart).setMultipartUploadID(uploadID).setMultipartUploadPartNumber(partNumber).build();
        this.requestID = requestId;
        this.openID = openID;
        this.excludeList = new ExcludeList();
        this.bufferPool = new BufferPool(config.getStreamBufferSize(), (int)(config.getStreamBufferMaxSize() / (long)config.getStreamBufferSize()), ByteStringConversion.createByteBufferConversion((boolean)unsafeByteBufferConversion));
    }

    @VisibleForTesting
    BlockOutputStreamEntryPool() {
        this.streamEntries = new ArrayList<BlockOutputStreamEntry>();
        this.omClient = null;
        this.keyArgs = null;
        this.xceiverClientFactory = null;
        this.config = (OzoneClientConfig)new OzoneConfiguration().getObject(OzoneClientConfig.class);
        this.config.setStreamBufferSize(0);
        this.config.setStreamBufferMaxSize(0L);
        this.config.setStreamBufferFlushSize(0L);
        this.config.setStreamBufferFlushDelay(false);
        this.requestID = null;
        int chunkSize = 0;
        this.bufferPool = new BufferPool(chunkSize, 1);
        this.currentStreamIndex = 0;
        this.openID = -1L;
        this.excludeList = new ExcludeList();
    }

    public void addPreallocateBlocks(OmKeyLocationInfoGroup version, long openVersion) throws IOException {
        for (OmKeyLocationInfo subKeyInfo : version.getLocationList(Long.valueOf(openVersion))) {
            this.addKeyLocationInfo(subKeyInfo);
        }
    }

    private void addKeyLocationInfo(OmKeyLocationInfo subKeyInfo) {
        Preconditions.checkNotNull((Object)subKeyInfo.getPipeline());
        BlockOutputStreamEntry.Builder builder = new BlockOutputStreamEntry.Builder().setBlockID(subKeyInfo.getBlockID()).setKey(this.keyArgs.getKeyName()).setXceiverClientManager(this.xceiverClientFactory).setPipeline(subKeyInfo.getPipeline()).setConfig(this.config).setLength(subKeyInfo.getLength()).setBufferPool(this.bufferPool).setToken((Token<OzoneBlockTokenIdentifier>)subKeyInfo.getToken());
        this.streamEntries.add(builder.build());
    }

    public List<OmKeyLocationInfo> getLocationInfoList() {
        ArrayList<OmKeyLocationInfo> locationInfoList = new ArrayList<OmKeyLocationInfo>();
        for (BlockOutputStreamEntry streamEntry : this.streamEntries) {
            long length = streamEntry.getCurrentPosition();
            if (length != 0L) {
                OmKeyLocationInfo info = new OmKeyLocationInfo.Builder().setBlockID(streamEntry.getBlockID()).setLength(streamEntry.getCurrentPosition()).setOffset(0L).setToken(streamEntry.getToken()).setPipeline(streamEntry.getPipeline()).build();
                locationInfoList.add(info);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("block written " + streamEntry.getBlockID() + ", length " + length + " bcsID " + streamEntry.getBlockID().getBlockCommitSequenceId());
        }
        return locationInfoList;
    }

    void discardPreallocatedBlocks(long containerID, PipelineID pipelineId) {
        if (this.currentStreamIndex + 1 < this.streamEntries.size()) {
            ListIterator<BlockOutputStreamEntry> streamEntryIterator = this.streamEntries.listIterator(this.currentStreamIndex + 1);
            while (streamEntryIterator.hasNext()) {
                BlockOutputStreamEntry streamEntry = streamEntryIterator.next();
                Preconditions.checkArgument((streamEntry.getCurrentPosition() == 0L ? 1 : 0) != 0);
                if (!streamEntry.getPipeline().getId().equals((Object)pipelineId) && (containerID == -1L || streamEntry.getBlockID().getContainerID() != containerID)) continue;
                streamEntryIterator.remove();
            }
        }
    }

    List<BlockOutputStreamEntry> getStreamEntries() {
        return this.streamEntries;
    }

    XceiverClientFactory getXceiverClientFactory() {
        return this.xceiverClientFactory;
    }

    String getKeyName() {
        return this.keyArgs.getKeyName();
    }

    long getKeyLength() {
        return this.streamEntries.stream().mapToLong(BlockOutputStreamEntry::getCurrentPosition).sum();
    }

    private void allocateNewBlock() throws IOException {
        if (!this.excludeList.isEmpty()) {
            LOG.info("Allocating block with {}", (Object)this.excludeList);
        }
        OmKeyLocationInfo subKeyInfo = this.omClient.allocateBlock(this.keyArgs, this.openID, this.excludeList);
        this.addKeyLocationInfo(subKeyInfo);
    }

    void commitKey(long offset) throws IOException {
        if (this.keyArgs != null) {
            long length = this.getKeyLength();
            Preconditions.checkArgument((offset == length ? 1 : 0) != 0);
            this.keyArgs.setDataSize(length);
            this.keyArgs.setLocationInfoList(this.getLocationInfoList());
            if (this.keyArgs.getIsMultipartKey()) {
                this.commitUploadPartInfo = this.omClient.commitMultipartUploadPart(this.keyArgs, this.openID);
            } else {
                this.omClient.commitKey(this.keyArgs, this.openID);
            }
        } else {
            LOG.warn("Closing KeyOutputStream, but key args is null");
        }
    }

    public BlockOutputStreamEntry getCurrentStreamEntry() {
        if (this.streamEntries.isEmpty() || this.streamEntries.size() <= this.currentStreamIndex) {
            return null;
        }
        return this.streamEntries.get(this.currentStreamIndex);
    }

    BlockOutputStreamEntry allocateBlockIfNeeded() throws IOException {
        BlockOutputStreamEntry streamEntry = this.getCurrentStreamEntry();
        if (streamEntry != null && streamEntry.isClosed()) {
            ++this.currentStreamIndex;
        }
        if (this.streamEntries.size() <= this.currentStreamIndex) {
            Preconditions.checkNotNull((Object)this.omClient);
            this.allocateNewBlock();
        }
        Preconditions.checkArgument((this.currentStreamIndex < this.streamEntries.size() ? 1 : 0) != 0);
        return this.streamEntries.get(this.currentStreamIndex);
    }

    long computeBufferData() {
        return this.bufferPool.computeBufferData();
    }

    void cleanup() {
        if (this.excludeList != null) {
            this.excludeList.clear();
        }
        if (this.bufferPool != null) {
            this.bufferPool.clearBufferPool();
        }
        if (this.streamEntries != null) {
            this.streamEntries.clear();
        }
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        return this.commitUploadPartInfo;
    }

    public ExcludeList getExcludeList() {
        return this.excludeList;
    }

    boolean isEmpty() {
        return this.streamEntries.isEmpty();
    }
}

