/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.OzoneClientConfig;
import org.apache.hadoop.hdds.scm.XceiverClientFactory;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.storage.BlockOutputStream;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.security.token.Token;

public final class BlockOutputStreamEntry
extends OutputStream {
    private final OzoneClientConfig config;
    private OutputStream outputStream;
    private BlockID blockID;
    private final String key;
    private final XceiverClientFactory xceiverClientManager;
    private final Pipeline pipeline;
    private final long length;
    private long currentPosition;
    private final Token<OzoneBlockTokenIdentifier> token;
    private BufferPool bufferPool;

    private BlockOutputStreamEntry(BlockID blockID, String key, XceiverClientFactory xceiverClientManager, Pipeline pipeline, long length, BufferPool bufferPool, Token<OzoneBlockTokenIdentifier> token, OzoneClientConfig config) {
        this.config = config;
        this.outputStream = null;
        this.blockID = blockID;
        this.key = key;
        this.xceiverClientManager = xceiverClientManager;
        this.pipeline = pipeline;
        this.token = token;
        this.length = length;
        this.currentPosition = 0L;
        this.bufferPool = bufferPool;
    }

    long getLength() {
        return this.length;
    }

    Token<OzoneBlockTokenIdentifier> getToken() {
        return this.token;
    }

    long getRemaining() {
        return this.length - this.currentPosition;
    }

    private void checkStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new BlockOutputStream(this.blockID, this.xceiverClientManager, this.pipeline, this.bufferPool, this.config, this.token);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkStream();
        this.outputStream.write(b);
        ++this.currentPosition;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkStream();
        this.outputStream.write(b, off, len);
        this.currentPosition += (long)len;
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.blockID = ((BlockOutputStream)this.outputStream).getBlockID();
        }
    }

    boolean isClosed() {
        if (this.outputStream != null) {
            return ((BlockOutputStream)this.outputStream).isClosed();
        }
        return false;
    }

    long getTotalAckDataLength() {
        if (this.outputStream != null) {
            BlockOutputStream out = (BlockOutputStream)this.outputStream;
            this.blockID = out.getBlockID();
            return out.getTotalAckDataLength();
        }
        return 0L;
    }

    Collection<DatanodeDetails> getFailedServers() {
        if (this.outputStream != null) {
            BlockOutputStream out = (BlockOutputStream)this.outputStream;
            return out.getFailedServers();
        }
        return Collections.emptyList();
    }

    long getWrittenDataLength() {
        if (this.outputStream != null) {
            BlockOutputStream out = (BlockOutputStream)this.outputStream;
            return out.getWrittenDataLength();
        }
        return 0L;
    }

    void cleanup(boolean invalidateClient) throws IOException {
        this.checkStream();
        BlockOutputStream out = (BlockOutputStream)this.outputStream;
        out.cleanup(invalidateClient);
    }

    void writeOnRetry(long len) throws IOException {
        this.checkStream();
        BlockOutputStream out = (BlockOutputStream)this.outputStream;
        out.writeOnRetry(len);
        this.currentPosition += len;
    }

    @VisibleForTesting
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public BlockID getBlockID() {
        return this.blockID;
    }

    public String getKey() {
        return this.key;
    }

    public XceiverClientFactory getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public void setCurrentPosition(long curPosition) {
        this.currentPosition = curPosition;
    }

    public static class Builder {
        private BlockID blockID;
        private String key;
        private XceiverClientFactory xceiverClientManager;
        private Pipeline pipeline;
        private long length;
        private BufferPool bufferPool;
        private Token<OzoneBlockTokenIdentifier> token;
        private OzoneClientConfig config;

        public Builder setBlockID(BlockID bID) {
            this.blockID = bID;
            return this;
        }

        public Builder setKey(String keys) {
            this.key = keys;
            return this;
        }

        public Builder setXceiverClientManager(XceiverClientFactory xClientManager) {
            this.xceiverClientManager = xClientManager;
            return this;
        }

        public Builder setPipeline(Pipeline ppln) {
            this.pipeline = ppln;
            return this;
        }

        public Builder setLength(long len) {
            this.length = len;
            return this;
        }

        public Builder setBufferPool(BufferPool pool) {
            this.bufferPool = pool;
            return this;
        }

        public Builder setConfig(OzoneClientConfig clientConfig) {
            this.config = clientConfig;
            return this;
        }

        public Builder setToken(Token<OzoneBlockTokenIdentifier> bToken) {
            this.token = bToken;
            return this;
        }

        public BlockOutputStreamEntry build() {
            return new BlockOutputStreamEntry(this.blockID, this.key, this.xceiverClientManager, this.pipeline, this.length, this.bufferPool, this.token, this.config);
        }
    }
}

