/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.time.Instant;
import org.apache.hadoop.hdds.client.ReplicationType;

public class OzoneKey {
    private final String volumeName;
    private final String bucketName;
    private final String name;
    private final long dataSize;
    private Instant creationTime;
    private Instant modificationTime;
    private ReplicationType replicationType;
    private int replicationFactor;

    public OzoneKey(String volumeName, String bucketName, String keyName, long size, long creationTime, long modificationTime, ReplicationType type, int replicationFactor) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.name = keyName;
        this.dataSize = size;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
        this.replicationType = type;
        this.replicationFactor = replicationFactor;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getName() {
        return this.name;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public ReplicationType getReplicationType() {
        return this.replicationType;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }
}

