/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.client.ObjectStore;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;

public class OzoneClient
implements Closeable {
    private final ClientProtocol proxy;
    private final ObjectStore objectStore;
    private ConfigurationSource conf;

    public OzoneClient(ConfigurationSource conf, ClientProtocol proxy) {
        this.proxy = proxy;
        this.objectStore = new ObjectStore(conf, this.proxy);
        this.conf = conf;
    }

    @VisibleForTesting
    protected OzoneClient(ObjectStore objectStore) {
        this.objectStore = objectStore;
        this.proxy = null;
        this.conf = new OzoneConfiguration();
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public ConfigurationSource getConfiguration() {
        return this.conf;
    }

    @Override
    public void close() throws IOException {
        this.proxy.close();
    }
}

